/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.httpfacade;

import com.taotao.boot.common.httpfacade.HttpClient;
import com.taotao.boot.common.httpfacade.HttpClientConfig;
import com.taotao.boot.common.httpfacade.HttpClientException;
import com.taotao.boot.common.httpfacade.HttpRequest;
import com.taotao.boot.common.httpfacade.HttpResponse;
import com.taotao.boot.common.httpfacade.RequestFilter;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

abstract class BaseHttpClient
implements HttpClient {
    protected final HttpClientConfig config;
    private Duration timeout = Duration.ofSeconds(30L);

    public BaseHttpClient(HttpClientConfig config) {
        this.config = config;
        if (this.config.timeout() != null) {
            this.timeout = this.config.timeout();
        }
    }

    @Override
    public CompletableFuture<HttpResponse> send(HttpRequest request) {
        for (RequestFilter requestFilter : this.config.requestFilters()) {
            request = requestFilter.filter(request);
        }
        return this.innerSend(request);
    }

    protected abstract CompletableFuture<HttpResponse> innerSend(HttpRequest var1);

    @Override
    public HttpResponse sendSync(HttpRequest request) {
        try {
            CompletableFuture<HttpResponse> future = this.send(request);
            return future.get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new HttpClientException("Request timed out after " + this.timeout.getSeconds() + " seconds", e);
        }
        catch (Exception e) {
            throw new HttpClientException("Failed to execute synchronous request", e);
        }
    }
}

