/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.httpfacade;

import com.taotao.boot.common.httpfacade.HttpMethod;
import com.taotao.boot.common.httpfacade.HttpServer;
import com.taotao.boot.common.httpfacade.HttpServerConfig;
import com.taotao.boot.common.httpfacade.PathUtil;
import com.taotao.boot.common.httpfacade.RequestHandler;
import com.taotao.boot.common.httpfacade.Route;
import com.taotao.boot.common.httpfacade.SyncRequestHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;

abstract class BaseHttpServer
implements HttpServer {
    protected final HttpServerConfig config;
    protected final Map<HttpMethod, Map<String, Route>> routes = new HashMap<HttpMethod, Map<String, Route>>();

    public BaseHttpServer(HttpServerConfig config) {
        this.config = config;
    }

    @Override
    public void addRoute(String path, HttpMethod method, RequestHandler handler) {
        Route route = BaseHttpServer.toRoute(path, method, handler);
        this.routes.computeIfAbsent(method, k -> new HashMap()).put(path, route);
        this.addRoute(route);
    }

    @Override
    public void addSyncRoute(String path, HttpMethod method, SyncRequestHandler handler) {
        this.addRoute(path, method, request -> CompletableFuture.completedFuture(handler.handle(request)));
    }

    protected abstract void addRoute(Route var1);

    private static Route toRoute(String path, HttpMethod method, RequestHandler handler) {
        String regexPath = PathUtil.pathToRegex(path);
        String[] pathVariableNames = PathUtil.extractPathVariableKeys(path);
        return new Route(method, path, Pattern.compile(regexPath), pathVariableNames, handler);
    }
}

