/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.httpfacade;

import com.taotao.boot.common.httpfacade.HttpMethod;
import com.taotao.boot.common.httpfacade.HttpRequest;
import com.taotao.boot.common.httpfacade.HttpResponse;
import jakarta.validation.constraints.NotNull;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface HttpClient
extends Closeable {
    public CompletableFuture<HttpResponse> send(HttpRequest var1);

    public HttpResponse sendSync(HttpRequest var1);

    default public CompletableFuture<HttpResponse> post(String url, byte[] body) {
        return this.send(new HttpRequest(url, HttpMethod.POST, body));
    }

    default public CompletableFuture<HttpResponse> post(String url, byte[] body, Map<String, List<String>> headers) {
        return this.send(new HttpRequest(url, HttpMethod.POST, headers, body));
    }

    default public CompletableFuture<HttpResponse> put(String url, byte[] body) {
        return this.send(new HttpRequest(url, HttpMethod.PUT, body));
    }

    default public CompletableFuture<HttpResponse> put(String url, byte[] body, Map<String, List<String>> headers) {
        return this.send(new HttpRequest(url, HttpMethod.PUT, headers, body));
    }

    default public CompletableFuture<HttpResponse> delete(String url) {
        return this.send(new HttpRequest(url, HttpMethod.DELETE));
    }

    default public CompletableFuture<HttpResponse> delete(String url, Map<String, List<String>> headers) {
        return this.send(new HttpRequest(url, HttpMethod.DELETE, headers));
    }

    default public CompletableFuture<HttpResponse> get(String url) {
        return this.send(new HttpRequest(url, HttpMethod.GET));
    }

    default public CompletableFuture<HttpResponse> get(String url, Map<String, List<String>> headers) {
        return this.send(new HttpRequest(url, HttpMethod.GET, headers));
    }

    @NotNull
    default public HttpResponse postSync(String url, byte[] body) {
        return this.sendSync(new HttpRequest(url, HttpMethod.POST, body));
    }

    @NotNull
    default public HttpResponse postSync(String url, byte[] body, Map<String, List<String>> headers) {
        return this.sendSync(new HttpRequest(url, HttpMethod.POST, headers, body));
    }

    @NotNull
    default public HttpResponse putSync(String url, byte[] body) {
        return this.sendSync(new HttpRequest(url, HttpMethod.PUT, body));
    }

    @NotNull
    default public HttpResponse putSync(String url, byte[] body, Map<String, List<String>> headers) {
        return this.sendSync(new HttpRequest(url, HttpMethod.PUT, headers, body));
    }

    @NotNull
    default public HttpResponse deleteSync(String url) {
        return this.sendSync(new HttpRequest(url, HttpMethod.DELETE));
    }

    @NotNull
    default public HttpResponse deleteSync(String url, Map<String, List<String>> headers) {
        return this.sendSync(new HttpRequest(url, HttpMethod.DELETE, headers));
    }

    @NotNull
    default public HttpResponse getSync(String url) {
        return this.sendSync(new HttpRequest(url, HttpMethod.GET));
    }

    @NotNull
    default public HttpResponse getSync(String url, Map<String, List<String>> headers) {
        return this.sendSync(new HttpRequest(url, HttpMethod.GET, headers));
    }

    @Override
    default public void close() throws IOException {
    }
}

