/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.httpfacade;

import com.taotao.boot.common.httpfacade.HttpClientEngine;
import com.taotao.boot.common.httpfacade.RequestFilter;
import com.taotao.boot.common.httpfacade.TlsConfig;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class HttpClientConfig {
    private HttpClientEngine engine;
    private Duration timeout;
    private Duration connectTimeout;
    private List<RequestFilter> requestFilters;
    private TlsConfig tlsConfig;
    private OkHttpConfig okHttpConfig;

    private HttpClientConfig(Builder builder) {
        this.engine = builder.engine;
        this.timeout = builder.timeout;
        this.connectTimeout = builder.connectTimeout;
        this.requestFilters = builder.requestFilters;
        this.tlsConfig = builder.tlsConfig;
        this.okHttpConfig = builder.okHttpConfig;
    }

    public HttpClientEngine getEngine() {
        return this.engine;
    }

    public void setEngine(HttpClientEngine engine) {
        this.engine = engine;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public List<RequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    public void setRequestFilters(List<RequestFilter> requestFilters) {
        this.requestFilters = requestFilters;
    }

    public TlsConfig getTlsConfig() {
        return this.tlsConfig;
    }

    public void setTlsConfig(TlsConfig tlsConfig) {
        this.tlsConfig = tlsConfig;
    }

    public OkHttpConfig getOkHttpConfig() {
        return this.okHttpConfig;
    }

    public void setOkHttpConfig(OkHttpConfig okHttpConfig) {
        this.okHttpConfig = okHttpConfig;
    }

    public HttpClientEngine engine() {
        return this.engine;
    }

    public Duration timeout() {
        return this.timeout;
    }

    public Duration connectTimeout() {
        return this.connectTimeout;
    }

    @NotNull
    public List<RequestFilter> addRequestFilter(RequestFilter filter) {
        this.requestFilters.add(filter);
        return this.requestFilters;
    }

    @NotNull
    public List<RequestFilter> requestFilters() {
        return this.requestFilters;
    }

    public TlsConfig tlsConfig() {
        return this.tlsConfig;
    }

    public OkHttpConfig okHttpConfig() {
        return this.okHttpConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpClientConfig{\n");
        sb.append("engine=").append((Object)this.engine).append("\n");
        if (this.timeout != null) {
            sb.append("timeout=").append(this.timeout).append("\n");
        }
        if (this.connectTimeout != null) {
            sb.append("connectTimeout=").append(this.connectTimeout).append("\n");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig=").append(this.tlsConfig).append("\n");
        }
        if (this.okHttpConfig != null) {
            sb.append("okHttpConfig=").append(this.okHttpConfig).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        private HttpClientEngine engine;
        private Duration timeout;
        private Duration connectTimeout;
        private List<RequestFilter> requestFilters = new ArrayList<RequestFilter>();
        private TlsConfig tlsConfig;
        private OkHttpConfig okHttpConfig;

        public Builder engine(HttpClientEngine engine) {
            this.engine = engine;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder requestFilter(List<RequestFilter> requestFilters) {
            this.requestFilters = requestFilters;
            return this;
        }

        public Builder addRequestFilter(RequestFilter filter) {
            this.requestFilters.add(filter);
            return this;
        }

        public Builder tlsConfig(TlsConfig tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        public Builder okHttpConfig(OkHttpConfig okHttpConfig) {
            this.okHttpConfig = okHttpConfig;
            return this;
        }

        public HttpClientConfig build() {
            return new HttpClientConfig(this);
        }
    }

    public static class OkHttpConfig {
        private boolean retryOnConnectionFailure;
        private ConnectionPoolConfig connectionPoolConfig;

        public boolean retryOnConnectionFailure() {
            return this.retryOnConnectionFailure;
        }

        public ConnectionPoolConfig connectionPoolConfig() {
            return this.connectionPoolConfig;
        }

        public boolean isRetryOnConnectionFailure() {
            return this.retryOnConnectionFailure;
        }

        public ConnectionPoolConfig getConnectionPoolConfig() {
            return this.connectionPoolConfig;
        }

        public void setRetryOnConnectionFailure(boolean retryOnConnectionFailure) {
            this.retryOnConnectionFailure = retryOnConnectionFailure;
        }

        public void setConnectionPoolConfig(ConnectionPoolConfig connectionPoolConfig) {
            this.connectionPoolConfig = connectionPoolConfig;
        }

        public static class ConnectionPoolConfig {
            private int maxIdleConnections;
            private Duration keepAliveDuration;

            public int maxIdleConnections() {
                return this.maxIdleConnections;
            }

            public Duration keepAliveDuration() {
                return this.keepAliveDuration;
            }

            public ConnectionPoolConfig() {
            }

            public ConnectionPoolConfig(int maxIdleConnections, Duration keepAliveDuration) {
                this.maxIdleConnections = maxIdleConnections;
                this.keepAliveDuration = keepAliveDuration;
            }

            public int getMaxIdleConnections() {
                return this.maxIdleConnections;
            }

            public void setMaxIdleConnections(int maxIdleConnections) {
                this.maxIdleConnections = maxIdleConnections;
            }

            public Duration getKeepAliveDuration() {
                return this.keepAliveDuration;
            }

            public void setKeepAliveDuration(Duration keepAliveDuration) {
                this.keepAliveDuration = keepAliveDuration;
            }
        }
    }
}

