/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.httpfacade;

import com.taotao.boot.common.httpfacade.AsyncHttpClient;
import com.taotao.boot.common.httpfacade.HttpClient;
import com.taotao.boot.common.httpfacade.HttpClientConfig;
import com.taotao.boot.common.httpfacade.HttpClientEngine;
import com.taotao.boot.common.httpfacade.Java8HttpClient;
import com.taotao.boot.common.httpfacade.JavaHttpClient;
import com.taotao.boot.common.httpfacade.OkHttpClient;
import java.time.Duration;

public class HttpClientFactory {
    public static HttpClient createHttpClient(HttpClientConfig httpClientConfig) {
        HttpClientEngine engine;
        HttpClientEngine httpClientEngine = engine = httpClientConfig.engine() != null ? httpClientConfig.engine() : HttpClientFactory.detectDefaultEngine();
        if (httpClientConfig.connectTimeout() == null) {
            httpClientConfig.setConnectTimeout(Duration.ofSeconds(10L));
        }
        if (httpClientConfig.timeout() == null) {
            httpClientConfig.setTimeout(Duration.ofSeconds(30L));
        }
        return switch (engine) {
            case HttpClientEngine.AsyncHttpClient -> new AsyncHttpClient(httpClientConfig);
            case HttpClientEngine.JAVA -> new JavaHttpClient(httpClientConfig);
            case HttpClientEngine.JAVA8 -> new Java8HttpClient(httpClientConfig);
            case HttpClientEngine.OkHttp -> new OkHttpClient(httpClientConfig);
            default -> throw new IllegalStateException("Unsupported HttpClient engine: " + String.valueOf((Object)httpClientConfig.engine()));
        };
    }

    private static HttpClientEngine detectDefaultEngine() {
        try {
            Class.forName("java.net.http.HttpClient");
            return HttpClientEngine.JAVA;
        }
        catch (ClassNotFoundException e) {
            return HttpClientEngine.JAVA8;
        }
    }
}

