/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.httpfacade;

import com.taotao.boot.common.httpfacade.HttpMethod;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpRequest {
    @NotNull
    private final String url;
    @NotNull
    private final HttpMethod method;
    @NotNull
    private final Map<String, List<String>> headers;
    @Nullable
    private byte[] body;
    private Map<String, String> pathVariables;
    private Map<String, List<String>> queryParams;

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @NotNull
    public HttpMethod getMethod() {
        return this.method;
    }

    @NotNull
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Nullable
    public byte[] getBody() {
        return this.body;
    }

    public void setBody(@Nullable byte[] body) {
        this.body = body;
    }

    public Map<String, String> getPathVariables() {
        return this.pathVariables;
    }

    public void setPathVariables(Map<String, String> pathVariables) {
        this.pathVariables = pathVariables;
    }

    public Map<String, List<String>> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Map<String, List<String>> queryParams) {
        this.queryParams = queryParams;
    }

    public HttpRequest(@NotNull String url, @NotNull HttpMethod method) {
        this.url = url;
        this.method = method;
        this.headers = new HashMap<String, List<String>>();
    }

    public HttpRequest(@NotNull String url, @NotNull HttpMethod method, @NotNull Map<String, List<String>> headers) {
        this.url = url;
        this.method = method;
        this.headers = headers;
    }

    public HttpRequest(@NotNull String url, @NotNull HttpMethod method, @Nullable byte[] body) {
        this.url = url;
        this.method = method;
        this.headers = new HashMap<String, List<String>>();
        this.body = body;
    }

    public HttpRequest(@NotNull String url, @NotNull HttpMethod method, @NotNull Map<String, List<String>> headers, @Nullable byte[] body) {
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.body = body;
    }

    @NotNull
    public String url() {
        return this.url;
    }

    @NotNull
    public HttpMethod method() {
        return this.method;
    }

    @NotNull
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public void addHeader(@NotNull String key, @NotNull String value) {
        this.headers.putIfAbsent(key, new ArrayList());
        this.headers.get(key).add(value);
    }

    public void addHeader(@NotNull String key, @NotNull List<String> value) {
        if (this.headers.get(key) == null) {
            this.headers.put(key, value);
        } else {
            this.headers.get(key).addAll(value);
        }
    }

    @Nullable
    public byte[] body() {
        return this.body;
    }

    public Map<String, String> pathVariables() {
        return this.pathVariables;
    }

    public Map<String, List<String>> queryParams() {
        if (this.queryParams == null) {
            this.queryParams = new HashMap<String, List<String>>();
        }
        return this.queryParams;
    }

    public void addQueryParam(@NotNull String key, @NotNull String value) {
        if (this.queryParams == null) {
            this.queryParams = new HashMap<String, List<String>>();
        }
        this.queryParams.putIfAbsent(key, new ArrayList());
        this.queryParams.get(key).add(value);
    }

    public void addQueryParam(@NotNull String key, @NotNull List<String> value) {
        if (this.queryParams == null) {
            this.queryParams = new HashMap<String, List<String>>();
        }
        if (this.queryParams.get(key) == null) {
            this.queryParams.put(key, value);
        } else {
            this.queryParams.get(key).addAll(value);
        }
    }
}

