/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.httpfacade;

import jakarta.validation.constraints.NotNull;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpResponse {
    private final int statusCode;
    @NotNull
    private final byte[] body;
    @NotNull
    private final Map<String, List<String>> headers;

    public HttpResponse(int statusCode) {
        this.statusCode = statusCode;
        this.body = new byte[0];
        this.headers = new HashMap<String, List<String>>();
    }

    public HttpResponse(int statusCode, @NotNull byte[] body) {
        this.statusCode = statusCode;
        this.body = body;
        this.headers = new HashMap<String, List<String>>();
    }

    public HttpResponse(int statusCode, @NotNull byte[] body, @NotNull Map<String, List<String>> headers) {
        this.statusCode = statusCode;
        this.body = body;
        this.headers = headers;
    }

    public int statusCode() {
        return this.statusCode;
    }

    @NotNull
    public byte[] body() {
        return this.body;
    }

    @NotNull
    public String bodyAsString() {
        return new String(this.body, StandardCharsets.UTF_8);
    }

    @NotNull
    public Map<String, List<String>> headers() {
        return this.headers;
    }
}

