/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.httpfacade;

import com.taotao.boot.common.httpfacade.HttpServerEngine;
import com.taotao.boot.common.httpfacade.TlsConfig;

public class HttpServerConfig {
    private HttpServerEngine engine;
    private String host;
    private int port;
    private TlsConfig tlsConfig;

    public HttpServerEngine getEngine() {
        return this.engine;
    }

    public void setEngine(HttpServerEngine engine) {
        this.engine = engine;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public TlsConfig getTlsConfig() {
        return this.tlsConfig;
    }

    public void setTlsConfig(TlsConfig tlsConfig) {
        this.tlsConfig = tlsConfig;
    }

    private HttpServerConfig(Builder builder) {
        this.engine = builder.engine;
        this.host = builder.host;
        this.port = builder.port;
        this.tlsConfig = builder.tlsConfig;
    }

    public HttpServerEngine engine() {
        return this.engine;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public TlsConfig tlsConfig() {
        return this.tlsConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpServerConfig{\n");
        sb.append("engine=").append((Object)this.engine).append("\n");
        sb.append("host=").append(this.host).append("\n");
        sb.append("port=").append(this.port).append("\n");
        if (this.tlsConfig != null) {
            sb.append("tlsConfig=").append(this.tlsConfig).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        private HttpServerEngine engine;
        private String host;
        private int port;
        private TlsConfig tlsConfig;

        public Builder engine(HttpServerEngine engine) {
            this.engine = engine;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder tlsConfig(TlsConfig tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        public HttpServerConfig build() {
            return new HttpServerConfig(this);
        }
    }
}

