/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.httpfacade;

import com.taotao.boot.common.httpfacade.BaseHttpClient;
import com.taotao.boot.common.httpfacade.HttpClientConfig;
import com.taotao.boot.common.httpfacade.HttpClientException;
import com.taotao.boot.common.httpfacade.HttpRequest;
import com.taotao.boot.common.httpfacade.HttpResponse;
import com.taotao.boot.common.httpfacade.RequestFilter;
import jakarta.validation.constraints.NotNull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class Java8HttpClient
extends BaseHttpClient {
    private final Duration connectTimeout;
    private final Duration timeout;

    public Java8HttpClient(HttpClientConfig config) {
        super(config);
        this.connectTimeout = config.connectTimeout();
        this.timeout = config.timeout();
    }

    @Override
    protected CompletableFuture<HttpResponse> innerSend(HttpRequest request) {
        return CompletableFuture.supplyAsync(() -> this.sendSync(request));
    }

    @Override
    public HttpResponse sendSync(HttpRequest request) {
        if (this.config.requestFilters() != null) {
            for (RequestFilter requestFilter : this.config.requestFilters()) {
                request = requestFilter.filter(request);
            }
        }
        HttpURLConnection connection = null;
        try {
            URL url = new URL(request.url());
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(request.method().name());
            if (this.connectTimeout != null) {
                connection.setConnectTimeout((int)this.connectTimeout.toMillis());
            }
            if (this.timeout != null) {
                connection.setReadTimeout((int)this.timeout.toMillis());
            }
            HttpURLConnection finalConnection = connection;
            request.headers().forEach((key, values) -> {
                for (String value : values) {
                    finalConnection.setRequestProperty((String)key, value);
                }
            });
            if (request.method().name().equals("POST") || request.method().name().equals("PUT")) {
                connection.setDoOutput(true);
                byte[] body = request.body();
                if (body != null) {
                    connection.getOutputStream().write(body);
                }
            }
            int statusCode = connection.getResponseCode();
            byte[] responseBody = Java8HttpClient.getBytes(connection);
            HttpResponse httpResponse = new HttpResponse(statusCode, responseBody, connection.getHeaderFields());
            return httpResponse;
        }
        catch (IOException e) {
            throw new HttpClientException("HttpURLConnection request failed", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @NotNull
    private static byte[] getBytes(HttpURLConnection connection) throws IOException {
        int bytesRead;
        InputStream inputStream = connection.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            byteArrayOutputStream.write(buffer, 0, bytesRead);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

