/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.httpfacade;

import com.taotao.boot.common.httpfacade.InsecureTrustManager;
import com.taotao.boot.common.httpfacade.TlsUtil;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class JdkSslContextUtil {
    public static SSLContext buildSSLContextFromJks(String keyStorePath, char[] keyStorePassword, String trustStorePath, char[] trustStorePassword, boolean disableSslVerify) {
        try {
            KeyManagerFactory keyManagerFactory = TlsUtil.initKeyManagerFactory(keyStorePath, keyStorePassword);
            TrustManagerFactory trustManagerFactory = null;
            if (trustStorePath != null) {
                trustManagerFactory = TlsUtil.initTrustManagerFactory(trustStorePath, trustStorePassword);
            }
            SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
            TrustManager[] trustManagers = disableSslVerify ? new TrustManager[]{InsecureTrustManager.INSTANCE} : (trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null);
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagers, new SecureRandom());
            if (disableSslVerify) {
                sslContext.getDefaultSSLParameters().setEndpointIdentificationAlgorithm(null);
            }
            return sslContext;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

