/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.httpfacade;

import com.taotao.boot.common.httpfacade.BaseHttpClient;
import com.taotao.boot.common.httpfacade.HttpClientConfig;
import com.taotao.boot.common.httpfacade.HttpClientException;
import com.taotao.boot.common.httpfacade.HttpRequest;
import com.taotao.boot.common.httpfacade.HttpResponse;
import com.taotao.boot.common.httpfacade.OkHttpSslContextFactory;
import com.taotao.boot.common.httpfacade.TlsConfig;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpClient
extends BaseHttpClient {
    private final okhttp3.OkHttpClient client;

    public OkHttpClient(HttpClientConfig config) {
        super(config);
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        if (config.connectTimeout() != null) {
            okHttpClientBuilder.connectTimeout(config.connectTimeout());
        }
        if (config.timeout() != null) {
            okHttpClientBuilder.readTimeout(config.timeout()).writeTimeout(config.timeout());
        }
        if (config.okHttpConfig() != null) {
            okHttpClientBuilder.retryOnConnectionFailure(config.okHttpConfig().retryOnConnectionFailure());
            HttpClientConfig.OkHttpConfig.ConnectionPoolConfig poolConfig = config.okHttpConfig().connectionPoolConfig();
            if (poolConfig != null) {
                int maxIdleConnections = poolConfig.maxIdleConnections();
                long keepAliveNanos = poolConfig.keepAliveDuration().toNanos();
                if (maxIdleConnections > 0 && keepAliveNanos > 0L) {
                    okHttpClientBuilder.connectionPool(new ConnectionPool(maxIdleConnections, keepAliveNanos, TimeUnit.NANOSECONDS));
                }
            }
        }
        if (config.tlsConfig() != null) {
            TlsConfig tlsConfig = config.tlsConfig();
            ConnectionSpec.Builder connectionSpecBuilder = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS);
            if (tlsConfig.versions() != null) {
                connectionSpecBuilder.tlsVersions(tlsConfig.versions());
            }
            if (tlsConfig.cipherSuites() != null) {
                connectionSpecBuilder.cipherSuites(tlsConfig.cipherSuites());
            }
            ConnectionSpec connectionSpec = connectionSpecBuilder.build();
            okHttpClientBuilder.connectionSpecs(Collections.singletonList(connectionSpec));
            OkHttpSslContextFactory.OkHttpSslContext sslContext = OkHttpSslContextFactory.createOkHttpSslContext(tlsConfig);
            okHttpClientBuilder.sslSocketFactory(sslContext.sslSocketFactory, sslContext.x509TrustManager);
            if (tlsConfig.hostnameVerifyDisabled()) {
                okHttpClientBuilder.hostnameVerifier((s, sslSession) -> true);
            }
        }
        this.client = okHttpClientBuilder.build();
    }

    @Override
    protected CompletableFuture<HttpResponse> innerSend(HttpRequest request) throws HttpClientException {
        Request okHttpRequest = this.buildOkHttpRequest(request);
        final CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
        this.client.newCall(okHttpRequest).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new HttpClientException("Async request failed", e));
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                future.complete(OkHttpClient.this.buildHttpResponse(response));
            }
        });
        return future;
    }

    @Override
    public void close() {
        this.client.dispatcher().executorService().shutdown();
        this.client.connectionPool().evictAll();
    }

    private Request buildOkHttpRequest(HttpRequest request) {
        Request.Builder builder = new Request.Builder().url(request.url()).method(request.method().name(), OkHttpClient.requestBody(request.body()));
        request.headers().forEach((name, values) -> {
            for (String value : values) {
                builder.addHeader(name, value);
            }
        });
        return builder.build();
    }

    @NotNull
    private HttpResponse buildHttpResponse(@NotNull Response response) throws IOException {
        byte[] body = OkHttpClient.getBody(response.body());
        return new HttpResponse(response.code(), body, response.headers().toMultimap());
    }

    @Nullable
    private static RequestBody requestBody(@Nullable byte[] body) {
        if (body == null) {
            return null;
        }
        return RequestBody.create((byte[])body);
    }

    @NotNull
    private static byte[] getBody(@Nullable ResponseBody responseBody) throws IOException {
        if (responseBody != null) {
            return responseBody.bytes();
        }
        return new byte[0];
    }
}

