/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.httpfacade;

import com.taotao.boot.common.httpfacade.InsecureTrustManager;
import com.taotao.boot.common.httpfacade.TlsConfig;
import jakarta.validation.constraints.NotNull;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class OkHttpSslContextFactory {
    OkHttpSslContextFactory() {
    }

    static OkHttpSslContext createOkHttpSslContext(TlsConfig tlsConfig) {
        try {
            KeyManager[] keyManagers = OkHttpSslContextFactory.getKeyManagers(tlsConfig.keyStorePath(), tlsConfig.keyStorePassword());
            TrustManager[] trustManagers = OkHttpSslContextFactory.getTrustManagers(tlsConfig.trustStorePath(), tlsConfig.trustStorePassword(), tlsConfig.verifyDisabled());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, new SecureRandom());
            X509TrustManager x509TrustManager = (X509TrustManager)trustManagers[0];
            return new OkHttpSslContext(sslContext.getSocketFactory(), x509TrustManager);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static KeyManager[] getKeyManagers(String keyStorePath, char[] keyStorePassword) {
        try {
            if (keyStorePath == null) {
                return null;
            }
            KeyStore keyStore = OkHttpSslContextFactory.loadKeyStore(keyStorePath, keyStorePassword);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keyStorePassword);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @NotNull
    private static TrustManager[] getTrustManagers(String trustStorePath, char[] trustStorePassword, boolean disableSslVerify) {
        try {
            if (disableSslVerify) {
                return new TrustManager[]{new InsecureTrustManager()};
            }
            KeyStore trustStore = OkHttpSslContextFactory.loadKeyStore(trustStorePath, trustStorePassword);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static KeyStore loadKeyStore(String keyStorePath, char[] password) {
        KeyStore keyStore;
        FileInputStream trustStoreFile = new FileInputStream(keyStorePath);
        try {
            KeyStore keyStore2 = KeyStore.getInstance("JKS");
            keyStore2.load(trustStoreFile, password);
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    trustStoreFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        trustStoreFile.close();
        return keyStore;
    }

    static class OkHttpSslContext {
        SSLSocketFactory sslSocketFactory;
        X509TrustManager x509TrustManager;

        public OkHttpSslContext(SSLSocketFactory sslSocketFactory, X509TrustManager x509TrustManager) {
            this.sslSocketFactory = sslSocketFactory;
            this.x509TrustManager = x509TrustManager;
        }

        public SSLSocketFactory getSslSocketFactory() {
            return this.sslSocketFactory;
        }

        public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
        }

        public X509TrustManager getX509TrustManager() {
            return this.x509TrustManager;
        }

        public void setX509TrustManager(X509TrustManager x509TrustManager) {
            this.x509TrustManager = x509TrustManager;
        }
    }
}

