/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.httpfacade;

import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathUtil {
    public static String[] extractPathVariableKeys(@NotNull String path) {
        Matcher matcher = Pattern.compile("\\{([^/]+)}").matcher(path);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        String[] keys = new String[count];
        matcher.reset();
        int i = 0;
        while (matcher.find()) {
            keys[i++] = matcher.group(1);
        }
        return keys;
    }

    public static String pathToRegex(@NotNull String path) {
        return path.replaceAll("\\{([^/]+)}", "([^/]+)");
    }

    @NotNull
    public static Map<String, String> extractPathVariableNames(@NotNull Pattern pattern, String[] pathVariableKeys, @NotNull String path) {
        HashMap<String, String> result = new HashMap<String, String>();
        Matcher matcher = pattern.matcher(path);
        if (!matcher.matches()) {
            return result;
        }
        int groupCount = matcher.groupCount();
        for (int i = 1; i <= groupCount; ++i) {
            String variableValue = matcher.group(i);
            result.put(pathVariableKeys[i - 1], variableValue);
        }
        return result;
    }

    public static String toVertxPath(@NotNull String path) {
        return path.replaceAll("\\{", ":").replaceAll("}", "");
    }
}

