/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.httpfacade;

import com.taotao.boot.common.httpfacade.HttpMethod;
import com.taotao.boot.common.httpfacade.HttpResponse;
import com.taotao.boot.common.httpfacade.ReactorHttpClientConfig;
import com.taotao.boot.common.httpfacade.ReactorSslContextFactory;
import com.taotao.boot.common.httpfacade.TlsConfig;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.ssl.SslContext;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientSecurityUtils;

public class ReactorHttpClient {
    private HttpClient client = HttpClient.create();

    public ReactorHttpClient(ReactorHttpClientConfig config) {
        this.client = this.client.responseTimeout(config.timeout());
        int connectionTimeoutMs = (int)config.connectTimeout().toMillis();
        this.client = (HttpClient)this.client.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectionTimeoutMs);
        if (config.tlsConfig() != null) {
            TlsConfig tlsConfig = config.tlsConfig();
            this.client = this.client.secure(spec -> {
                SslContext context = ReactorSslContextFactory.buildFromJks(tlsConfig.keyStorePath(), tlsConfig.keyStorePassword(), tlsConfig.trustStorePath(), tlsConfig.trustStorePassword(), tlsConfig.verifyDisabled(), tlsConfig.versions(), tlsConfig.cipherSuites());
                if (tlsConfig.hostnameVerifyDisabled()) {
                    spec.sslContext(context).handlerConfigurator(HttpClientSecurityUtils.HOSTNAME_VERIFICATION_CONFIGURER);
                } else {
                    spec.sslContext(context);
                }
            });
        }
    }

    public Mono<HttpResponse> send(HttpMethod method, Mono<String> url, Publisher<byte[]> body, @Nullable Map<String, List<String>> headers) {
        HttpClient httpClient = this.client;
        if (headers != null) {
            httpClient = this.client.headers(reactorHeaders -> headers.forEach((arg_0, arg_1) -> ((HttpHeaders)reactorHeaders).add(arg_0, arg_1)));
        }
        if (HttpMethod.POST.equals((Object)method)) {
            return this.handleResponse(((HttpClient.RequestSender)httpClient.post().uri(url)).send((req, out) -> out.sendByteArray(body)));
        }
        if (HttpMethod.PUT.equals((Object)method)) {
            return this.handleResponse(((HttpClient.RequestSender)httpClient.put().uri(url)).send((req, out) -> out.sendByteArray(body)));
        }
        if (HttpMethod.DELETE.equals((Object)method)) {
            return this.handleResponse((HttpClient.ResponseReceiver)httpClient.delete().uri(url));
        }
        if (HttpMethod.GET.equals((Object)method)) {
            return this.handleResponse((HttpClient.ResponseReceiver)httpClient.get().uri(url));
        }
        if (HttpMethod.HEAD.equals((Object)method)) {
            return this.handleResponse((HttpClient.ResponseReceiver)httpClient.head().uri(url));
        }
        if (HttpMethod.PATCH.equals((Object)method)) {
            return this.handleResponse(((HttpClient.RequestSender)httpClient.patch().uri(url)).send((req, out) -> out.sendByteArray(body)));
        }
        if (HttpMethod.OPTIONS.equals((Object)method)) {
            return this.handleResponse((HttpClient.ResponseReceiver)httpClient.options().uri(url));
        }
        throw new IllegalArgumentException("Unsupported HTTP method: " + String.valueOf((Object)method));
    }

    public Mono<HttpResponse> post(Mono<String> url, Publisher<byte[]> body) {
        return this.send(HttpMethod.POST, url, body, null);
    }

    public Mono<HttpResponse> post(Mono<String> url, Publisher<byte[]> body, Map<String, List<String>> headers) {
        return this.send(HttpMethod.POST, url, body, headers);
    }

    public Mono<HttpResponse> put(Mono<String> url, Publisher<byte[]> body) {
        return this.send(HttpMethod.PUT, url, body, null);
    }

    public Mono<HttpResponse> put(Mono<String> url, Publisher<byte[]> body, Map<String, List<String>> headers) {
        return this.send(HttpMethod.PUT, url, body, headers);
    }

    public Mono<HttpResponse> delete(Mono<String> url) {
        return this.send(HttpMethod.DELETE, url, (Publisher<byte[]>)Mono.empty(), null);
    }

    public Mono<HttpResponse> delete(Mono<String> url, Map<String, List<String>> headers) {
        return this.send(HttpMethod.DELETE, url, (Publisher<byte[]>)Mono.empty(), headers);
    }

    public Mono<HttpResponse> get(Mono<String> url) {
        return this.send(HttpMethod.GET, url, (Publisher<byte[]>)Mono.empty(), null);
    }

    public Mono<HttpResponse> get(Mono<String> url, Map<String, List<String>> headers) {
        return this.send(HttpMethod.GET, url, (Publisher<byte[]>)Mono.empty(), headers);
    }

    private Mono<HttpResponse> handleResponse(HttpClient.ResponseReceiver<?> responseReceiver) {
        return responseReceiver.responseSingle((response, content) -> {
            int code = response.status().code();
            HttpHeaders headers = response.responseHeaders();
            Mono byteBody = content.asByteArray();
            if (!headers.isEmpty()) {
                HashMap responseHeaders = new HashMap();
                headers.iteratorAsString().forEachRemaining(entry -> {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add((String)entry.getValue());
                    responseHeaders.put((String)entry.getKey(), list);
                });
                return byteBody.switchIfEmpty(Mono.just((Object)new byte[0])).map(responseBody -> new HttpResponse(code, (byte[])responseBody, responseHeaders));
            }
            return byteBody.switchIfEmpty(Mono.just((Object)new byte[0])).map(responseBody -> new HttpResponse(code, (byte[])responseBody));
        });
    }
}

