/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.httpfacade;

import jakarta.validation.constraints.NotNull;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class TlsUtil {
    @NotNull
    public static KeyStore loadKeyStore(String keyStorePath, char[] keyStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream keyStoreFile = new FileInputStream(keyStorePath);){
            keyStore.load(keyStoreFile, keyStorePassword);
        }
        return keyStore;
    }

    @NotNull
    public static KeyManagerFactory initKeyManagerFactory(String keyStorePath, char[] keyStorePassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        KeyStore keyStore = TlsUtil.loadKeyStore(keyStorePath, keyStorePassword);
        String defaultKeyAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(defaultKeyAlgorithm);
        keyManagerFactory.init(keyStore, keyStorePassword);
        return keyManagerFactory;
    }

    @NotNull
    public static TrustManagerFactory initTrustManagerFactory(String trustStorePath, char[] trustStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore trustStore = TlsUtil.loadKeyStore(trustStorePath, trustStorePassword);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        return trustManagerFactory;
    }
}

