/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.model;

import java.io.Serializable;
import java.util.function.Supplier;
import org.springframework.lang.Nullable;

public class Lazy<T>
implements Supplier<T>,
Serializable {
    @Nullable
    private transient Supplier<? extends T> supplier;
    @Nullable
    private volatile T value;

    public static <T> Lazy<T> of(Supplier<T> supplier) {
        return new Lazy<T>(supplier);
    }

    private Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    @Nullable
    public T get() {
        return this.supplier == null ? this.value : this.computeValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private synchronized T computeValue() {
        T result = this.value;
        if (null == result) {
            Lazy lazy = this;
            synchronized (lazy) {
                result = this.value;
                if (null == result) {
                    Supplier<T> s = this.supplier;
                    if (s == null) {
                        throw new RuntimeException("supplier is null");
                    }
                    this.value = s.get();
                    this.supplier = null;
                }
            }
        }
        return this.value;
    }
}

