/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.model;

import com.alibaba.fastjson2.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.taotao.boot.common.constant.CommonConstants;
import com.taotao.boot.common.enums.ResultEnum;
import com.taotao.boot.common.utils.common.IdGeneratorUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.common.utils.servlet.TraceUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.dromara.hutool.core.text.StrUtil;

@Schema(description="\u8fd4\u56de\u7ed3\u679c\u5bf9\u8c61")
public class RpcRequest<T>
implements Serializable {
    @Schema(description="\u72b6\u6001\u7801")
    private int code;
    @Schema(description="\u8fd4\u56de\u6570\u636e")
    private T data;
    @Schema(description="\u662f\u5426\u6210\u529f")
    private boolean success;
    @Schema(description="\u8bf7\u6c42\u6d88\u606f\u4f53")
    private String message;
    @Schema(description="\u5f02\u5e38\u6d88\u606f\u4f53")
    private String errorMsg;
    @Schema(description="\u8bf7\u6c42id")
    private String requestId;
    @Schema(description="\u8bf7\u6c42\u7ed3\u675f\u65f6\u95f4")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime timestamp;
    private static final long serialVersionUID = -3685249101751401211L;

    public static <T> RpcRequest<T> success(T data) {
        return RpcRequest.success(data, ResultEnum.SUCCESS.getCode());
    }

    public static RpcRequest<Boolean> success() {
        return RpcRequest.success(true);
    }

    public static RpcRequest<String> success(ResultEnum resultEnum) {
        return RpcRequest.of(resultEnum.getCode(), resultEnum.getDesc(), true, CommonConstants.REQUEST_SUCCESS, null);
    }

    public static <T> RpcRequest<T> success(T data, int code) {
        return RpcRequest.of(code, data, true, CommonConstants.REQUEST_SUCCESS, null);
    }

    public static RpcRequest<String> fail() {
        return RpcRequest.of(ResultEnum.ERROR.getCode(), null, false, CommonConstants.REQUEST_ERROR, ResultEnum.ERROR.getDesc());
    }

    public static <T> RpcRequest<T> fail(String errorMsg) {
        return RpcRequest.of(ResultEnum.ERROR.getCode(), null, false, CommonConstants.REQUEST_ERROR, errorMsg);
    }

    public static <T> RpcRequest<T> fail(String errorMsg, int code) {
        return RpcRequest.of(code, null, false, CommonConstants.REQUEST_ERROR, errorMsg);
    }

    public static <T> RpcRequest<T> fail(String errorMsg, String message, int code) {
        return RpcRequest.of(code, null, false, message, errorMsg);
    }

    public static RpcRequest<String> fail(ResultEnum resultEnum) {
        return RpcRequest.of(resultEnum.getCode(), null, false, CommonConstants.REQUEST_ERROR, resultEnum.getDesc());
    }

    public static <T> RpcRequest<T> fail(Throwable throwable) {
        LogUtils.error(throwable.getMessage(), new Object[0]);
        return RpcRequest.of(ResultEnum.ERROR.getCode(), null, false, CommonConstants.REQUEST_ERROR, ResultEnum.ERROR.getDesc());
    }

    public static <T> RpcRequest<T> validFail(ResultEnum resultEnum) {
        return RpcRequest.of(resultEnum.getCode(), null, false, CommonConstants.REQUEST_ERROR, resultEnum.getDesc());
    }

    public static <T> RpcRequest<T> validFail(String errorMsg, Object ... args) {
        return RpcRequest.of(ResultEnum.ERROR.getCode(), null, false, CommonConstants.REQUEST_ERROR, errorMsg);
    }

    public static <T> RpcRequest<T> validFail(String errorMsg) {
        return RpcRequest.of(ResultEnum.ERROR.getCode(), null, false, CommonConstants.REQUEST_ERROR, errorMsg);
    }

    public static <T> RpcRequest<T> of(int code, T data, boolean success, String message, String errorMsg) {
        return RpcRequest.builder().code(code).data(data).message(message).success(success).errorMsg(errorMsg).timestamp(LocalDateTime.now()).requestId(StrUtil.isNotBlank((CharSequence)TraceUtils.getTtcTraceId()) ? TraceUtils.getTtcTraceId() : IdGeneratorUtils.getIdStr()).build();
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return this.success && this.code == 200;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public static <T> RpcRequestBuilder<T> builder() {
        return new RpcRequestBuilder();
    }

    public static final class RpcRequestBuilder<T> {
        private int code;
        private T data;
        private boolean success;
        private String errorMsg;
        private String message;
        private String requestId;
        private LocalDateTime timestamp;

        private RpcRequestBuilder() {
        }

        public RpcRequestBuilder<T> code(int code) {
            this.code = code;
            return this;
        }

        public RpcRequestBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public RpcRequestBuilder<T> success(boolean success) {
            this.success = success;
            return this;
        }

        public RpcRequestBuilder<T> errorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        public RpcRequestBuilder<T> requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public RpcRequestBuilder<T> timestamp(LocalDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public RpcRequestBuilder<T> message(String message) {
            this.message = message;
            return this;
        }

        public RpcRequest<T> build() {
            RpcRequest<T> result = new RpcRequest<T>();
            result.setCode(this.code);
            result.setData(this.data);
            result.setSuccess(this.success);
            result.setMessage(this.message);
            result.setRequestId(this.requestId);
            result.setTimestamp(this.timestamp);
            result.setErrorMsg(this.errorMsg);
            return result;
        }
    }
}

