/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.model.clazz;

import com.taotao.boot.common.enums.ResultEnum;
import com.taotao.boot.common.utils.common.IdGeneratorUtils;
import com.taotao.boot.common.utils.servlet.MdcUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.dromara.hutool.core.text.StrUtil;

@Schema(description="\u8fd4\u56de\u7ed3\u679c\u5bf9\u8c61")
public class ResultClass<T>
implements Serializable {
    @Schema(description="\u72b6\u6001\u7801")
    private int code;
    @Schema(description="\u8fd4\u56de\u6570\u636e")
    private T data;
    @Schema(description="\u662f\u5426\u6210\u529f")
    private boolean success;
    @Schema(description="\u5f02\u5e38\u6d88\u606f\u4f53")
    private String errorMsg;
    @Schema(description="\u8bf7\u6c42id")
    private String requestId;
    @Schema(description="\u8bf7\u6c42\u7ed3\u675f\u65f6\u95f4")
    private LocalDateTime timestamp;
    private static final long serialVersionUID = -3685249101751401211L;

    public static <T> ResultClass<T> success(T data) {
        return ResultClass.of(ResultEnum.SUCCESS.getCode(), data, true, "");
    }

    public static <T> ResultClass<T> success(T data, int code) {
        return ResultClass.of(code, data, true, "");
    }

    public static ResultClass<String> success(ResultEnum resultEnum) {
        return ResultClass.of(resultEnum.getCode(), resultEnum.getDesc(), true, "");
    }

    public static ResultClass<String> fail() {
        return ResultClass.of(ResultEnum.ERROR.getCode(), null, false, ResultEnum.ERROR.getDesc());
    }

    public static <T> ResultClass<T> fail(String errorMsg) {
        return ResultClass.of(ResultEnum.ERROR.getCode(), null, false, errorMsg);
    }

    public static <T> ResultClass<T> fail(String data, int code) {
        return ResultClass.of(code, null, false, data);
    }

    public static ResultClass<String> fail(ResultEnum resultEnum) {
        return ResultClass.of(resultEnum.getCode(), null, false, resultEnum.getDesc());
    }

    public static <T> ResultClass<T> fail(Throwable throwable) {
        return ResultClass.of(ResultEnum.ERROR.getCode(), null, false, throwable.getMessage());
    }

    public static <T> ResultClass<T> validFail(ResultEnum resultEnum) {
        return ResultClass.of(resultEnum.getCode(), null, false, resultEnum.getDesc());
    }

    public static <T> ResultClass<T> validFail(String errorMsg, Object ... args) {
        return ResultClass.of(ResultEnum.ERROR.getCode(), null, false, errorMsg);
    }

    public static <T> ResultClass<T> validFail(String errorMsg) {
        return ResultClass.of(ResultEnum.ERROR.getCode(), null, false, errorMsg);
    }

    public static <T> ResultClass<T> of(int code, T data, boolean success, String errorMsg) {
        return ResultClass.builder().code(code).data(data).success(success).errorMsg(errorMsg).timestamp(LocalDateTime.now()).requestId(StrUtil.isNotBlank((CharSequence)MdcUtils.get("ttc-trace-id")) ? MdcUtils.get("ttc-trace-id") : IdGeneratorUtils.getIdStr()).build();
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public static <T> ResultBuilder<T> builder() {
        return new ResultBuilder();
    }

    public static final class ResultBuilder<T> {
        private int code;
        private T data;
        private boolean success;
        private String errorMsg;
        private String requestId;
        private LocalDateTime timestamp;

        private ResultBuilder() {
        }

        public ResultBuilder<T> code(int code) {
            this.code = code;
            return this;
        }

        public ResultBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public ResultBuilder<T> success(boolean success) {
            this.success = success;
            return this;
        }

        public ResultBuilder<T> errorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        public ResultBuilder<T> requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public ResultBuilder<T> timestamp(LocalDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ResultClass<T> build() {
            ResultClass<T> result = new ResultClass<T>();
            result.setCode(this.code);
            result.setData(this.data);
            result.setSuccess(this.success);
            result.setErrorMsg(this.errorMsg);
            result.setRequestId(this.requestId);
            result.setTimestamp(this.timestamp);
            return result;
        }
    }
}

