/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.model.clazz;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.taotao.boot.common.enums.ResultEnum;
import com.taotao.boot.common.utils.common.IdGeneratorUtils;
import com.taotao.boot.common.utils.servlet.MdcUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.dromara.hutool.core.text.StrUtil;

@Schema(description="\u8fd4\u56de\u7ed3\u679c\u5bf9\u8c61")
public record ResultRecord<T>(@Schema(description="\u72b6\u6001\u7801") int code, @Schema(description="\u8fd4\u56de\u6570\u636e") T data, @Schema(description="\u662f\u5426\u6210\u529f") boolean success, @Schema(description="\u5f02\u5e38\u6d88\u606f\u4f53") String errorMsg, @Schema(description="\u8bf7\u6c42id") String requestId, @Schema(description="\u8bf7\u6c42\u7ed3\u675f\u65f6\u95f4") @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime timestamp) implements Serializable
{
    private static final long serialVersionUID = -3685249101751401211L;

    public static <T> ResultRecord<T> of(int code, T data, boolean success, String errorMsg) {
        return new ResultRecord<T>(code, data, success, errorMsg, StrUtil.isNotBlank((CharSequence)MdcUtils.get("ttc-trace-id")) ? MdcUtils.get("ttc-trace-id") : IdGeneratorUtils.getIdStr(), LocalDateTime.now());
    }

    public static <T> ResultRecord<T> success(T data) {
        return ResultRecord.of(ResultEnum.SUCCESS.getCode(), data, true, "");
    }

    public static <T> ResultRecord<T> success(T data, int code) {
        return ResultRecord.of(code, data, true, "");
    }

    public static ResultRecord<String> success(String data, ResultEnum resultEnum) {
        return ResultRecord.of(resultEnum.getCode(), resultEnum.getDesc(), true, "");
    }

    public static ResultRecord<String> fail() {
        return ResultRecord.of(ResultEnum.ERROR.getCode(), null, false, ResultEnum.ERROR.getDesc());
    }

    public static <T> ResultRecord<T> fail(String errorMsg) {
        return ResultRecord.of(ResultEnum.ERROR.getCode(), null, false, errorMsg);
    }

    public static <T> ResultRecord<T> fail(String data, int code) {
        return ResultRecord.of(code, null, false, data);
    }

    public static ResultRecord<String> fail(ResultEnum resultEnum) {
        return ResultRecord.of(resultEnum.getCode(), null, false, resultEnum.getDesc());
    }

    public static <T> ResultRecord<T> fail(Throwable throwable) {
        return ResultRecord.of(ResultEnum.ERROR.getCode(), null, false, throwable.getMessage());
    }

    public static <T> ResultRecord<T> validFail(ResultEnum resultEnum) {
        return ResultRecord.of(resultEnum.getCode(), null, false, resultEnum.getDesc());
    }

    public static <T> ResultRecord<T> validFail(String errorMsg, Object ... args) {
        return ResultRecord.of(ResultEnum.ERROR.getCode(), null, false, errorMsg);
    }

    public static <T> ResultRecord<T> validFail(String errorMsg) {
        return ResultRecord.of(ResultEnum.ERROR.getCode(), null, false, errorMsg);
    }
}

