/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.support.hash;

import com.taotao.boot.common.support.hash.IConsistentHashing;
import com.taotao.boot.common.support.hash.api.IHashCode;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class ConsistentHashing<T>
implements IConsistentHashing<T> {
    private final int virtualNum;
    private final IHashCode hashCode;
    private final TreeMap<Integer, T> nodeMap = new TreeMap();

    public ConsistentHashing(int virtualNum, IHashCode hashCode) {
        this.virtualNum = virtualNum;
        this.hashCode = hashCode;
    }

    @Override
    public T get(String key) {
        int hashCode = this.hashCode.hash(key);
        Integer target = hashCode;
        if (!this.nodeMap.containsKey(hashCode) && (target = this.nodeMap.ceilingKey(hashCode)) == null && !this.nodeMap.isEmpty()) {
            target = this.nodeMap.firstKey();
        }
        return this.nodeMap.get(target);
    }

    @Override
    public IConsistentHashing add(T node) {
        for (int i = 0; i < this.virtualNum; ++i) {
            int nodeKey = this.hashCode.hash(node.toString() + "-" + i);
            this.nodeMap.put(nodeKey, node);
        }
        return this;
    }

    @Override
    public IConsistentHashing remove(T node) {
        for (int i = 0; i < this.virtualNum; ++i) {
            int nodeKey = this.hashCode.hash(node.toString() + "-" + i);
            this.nodeMap.remove(nodeKey);
        }
        return this;
    }

    @Override
    public Map<Integer, T> nodeMap() {
        return Collections.unmodifiableMap(this.nodeMap);
    }
}

