/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.support.hash.core;

import com.alibaba.fastjson2.JSONB;
import com.taotao.boot.common.support.hash.HashBs;
import com.taotao.boot.common.support.hash.api.IHash;
import com.taotao.boot.common.support.hash.api.IHashResultHandler;
import com.taotao.boot.common.support.hash.core.HashResultHandlers;
import com.taotao.boot.common.support.hash.core.Hashes;

public final class HashHelper {
    private HashHelper() {
    }

    public static String hash(String text) {
        return HashHelper.hash(Hashes.md5(), text);
    }

    public static String hash(IHash hash, String text) {
        return HashHelper.hash(hash, text, HashResultHandlers.hex());
    }

    public static <T> T hash(IHash hash, String text, IHashResultHandler<T> hashResultHandler) {
        return HashHelper.hash(hash, text, null, hashResultHandler);
    }

    public static <T> T hash(IHash hash, String text, String salt, IHashResultHandler<T> hashResultHandler) {
        return HashHelper.hash(hash, text, salt, 1, hashResultHandler);
    }

    public static <T> T hash(IHash hash, String text, String salt, int times, IHashResultHandler<T> hashResultHandler) {
        return HashBs.newInstance().hash(hash).salt(JSONB.toBytes((String)salt)).times(times).execute(JSONB.toBytes((String)text), hashResultHandler);
    }
}

