/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.support.oid;

import com.alibaba.fastjson2.annotation.JSONType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.taotao.boot.common.support.oid.OidDeserializer;
import com.taotao.boot.common.support.oid.OidSerializer;
import java.io.Serializable;
import java.util.Optional;
import org.dromara.hutool.core.text.StrUtil;

@JsonSerialize(using=OidSerializer.class)
@JsonDeserialize(using=OidDeserializer.class)
@JSONType(serializer=OidSerializer.class, deserializer=OidDeserializer.class)
public interface Oid
extends Serializable {
    public Optional<String> value();

    public static class NEW
    implements Oid {
        private String gid;

        private NEW(String gid) {
            this.gid = gid;
        }

        public static Oid from(String gid) {
            if (StrUtil.isBlank((CharSequence)gid)) {
                throw new IllegalArgumentException("oid \u4e0d\u80fd\u4e3a\u7a7a");
            }
            return new NEW(gid);
        }

        public String toString() {
            return this.gid;
        }

        @Override
        public Optional<String> value() {
            return Optional.of(this.gid);
        }
    }

    public static enum EMPTY implements Oid
    {
        INSTANCE;


        public String toString() {
            return "";
        }

        public boolean eq(Oid oid) {
            return oid != null && (oid.value().get() == null || oid.value().get().length() == 0);
        }

        @Override
        public Optional<String> value() {
            return Optional.of("");
        }
    }
}

