/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.support.oid;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.taotao.boot.common.support.oid.Oid;
import java.io.IOException;
import java.lang.reflect.Type;
import org.dromara.hutool.core.text.StrUtil;

public class OidDeserializer
extends StdDeserializer<Oid>
implements ObjectReader<Oid> {
    public OidDeserializer() {
        super(Oid.class);
    }

    public Oid readObject(JSONReader jsonReader, Type type, Object o, long l) {
        String string = jsonReader.getString();
        return this.getOid(string);
    }

    public Oid deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (jsonNode == null) {
            return Oid.EMPTY.INSTANCE;
        }
        return this.getOid(jsonNode.asText());
    }

    private Oid getOid(String oid) {
        if (StrUtil.isBlank((CharSequence)oid)) {
            return Oid.EMPTY.INSTANCE;
        }
        return Oid.NEW.from(oid);
    }
}

