/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.support.secret.core;

import com.taotao.boot.common.support.secret.exception.SecretRuntimeException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public final class DesUtil {
    private static final String DES = "DES";

    private DesUtil() {
    }

    public static byte[] encrypt(byte[] plainText, byte[] keyBytes) {
        try {
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(keyBytes);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
            SecretKey secretKey = keyFactory.generateSecret(desKey);
            Cipher cipher = Cipher.getInstance(DES);
            cipher.init(1, (Key)secretKey, random);
            return cipher.doFinal(plainText);
        }
        catch (Exception e) {
            throw new SecretRuntimeException(e);
        }
    }

    public static byte[] decrypt(byte[] cipherBytes, byte[] keyBytes) {
        try {
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(keyBytes);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
            SecretKey secretKey = keyFactory.generateSecret(desKey);
            Cipher cipher = Cipher.getInstance(DES);
            cipher.init(2, (Key)secretKey, random);
            return cipher.doFinal(cipherBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new SecretRuntimeException(e);
        }
    }
}

