/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.support.secret.core;

import com.taotao.boot.common.support.secret.api.ISecret;
import com.taotao.boot.common.support.secret.core.HexUtil;
import com.taotao.boot.common.support.secret.core.SecretContext;
import com.taotao.boot.common.support.secret.core.secret.Secrets;
import com.taotao.boot.common.utils.common.ArgUtils;
import com.taotao.boot.common.utils.lang.StringUtils;

public final class SecretBs {
    private ISecret secret = Secrets.base64();
    private String charset = "UTF-8";
    private byte[] key = new byte[0];

    private SecretBs() {
    }

    public static SecretBs newInstance() {
        return new SecretBs();
    }

    public SecretBs secret(ISecret secret) {
        ArgUtils.notNull(secret, "secret");
        this.secret = secret;
        return this;
    }

    public SecretBs key(byte[] key) {
        this.key = key;
        return this;
    }

    public SecretBs charset(String charset) {
        ArgUtils.notEmpty(charset, "charset");
        this.charset = charset;
        return this;
    }

    public byte[] encrypt(byte[] source) {
        SecretContext context = new SecretContext();
        context.key(this.key).source(source).charset(this.charset);
        return this.secret.encrypt(context);
    }

    public byte[] encrypt(String source) {
        byte[] sourceBytes = StringUtils.getBytes(source, this.charset);
        return this.encrypt(sourceBytes);
    }

    public String encryptToString(byte[] source) {
        byte[] encrypt = this.encrypt(source);
        return StringUtils.toString(encrypt, this.charset);
    }

    public String encryptToString(String source) {
        byte[] encrypt = this.encrypt(source);
        return StringUtils.toString(encrypt, this.charset);
    }

    public String encryptToHexString(byte[] source) {
        byte[] encrypt = this.encrypt(source);
        return HexUtil.byteToHexString(encrypt);
    }

    public String encryptToHexString(String source) {
        byte[] encrypt = this.encrypt(source);
        return HexUtil.byteToHexString(encrypt);
    }

    public byte[] decrypt(byte[] source) {
        SecretContext context = new SecretContext();
        context.key(this.key).source(source).charset(this.charset);
        return this.secret.decrypt(context);
    }

    public byte[] decrypt(String source) {
        byte[] sourceBytes = StringUtils.getBytes(source, this.charset);
        return this.decrypt(sourceBytes);
    }

    public String decryptToString(byte[] source) {
        byte[] decrypt = this.decrypt(source);
        return StringUtils.toString(decrypt, this.charset);
    }

    public String decryptToString(String source) {
        byte[] decrypt = this.decrypt(source);
        return StringUtils.toString(decrypt, this.charset);
    }

    public String decryptToHexString(byte[] source) {
        byte[] decrypt = this.decrypt(source);
        return HexUtil.byteToHexString(decrypt);
    }

    public String decryptToHexString(String source) {
        byte[] decrypt = this.decrypt(source);
        return HexUtil.byteToHexString(decrypt);
    }
}

