/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.support.secret.core;

import com.taotao.boot.common.support.secret.exception.SecretRuntimeException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.legacy.math.linearalgebra.ByteUtils;

public final class Sm4Util {
    private static final String ENCODING = "UTF-8";
    private static final String ALGORITHM_NAME = "SM4";
    private static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS5Padding";

    private Sm4Util() {
    }

    private static Cipher generateEcbCipher(String algorithmName, int mode, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        cipher.init(mode, sm4Key);
        return cipher;
    }

    public static String encryptEcb(String plainText, String hexKey) {
        try {
            String cipherText = "";
            byte[] keyData = ByteUtils.fromHexString((String)hexKey);
            byte[] srcData = plainText.getBytes(ENCODING);
            byte[] cipherArray = Sm4Util.encryptEcbPadding(keyData, srcData);
            cipherText = ByteUtils.toHexString((byte[])cipherArray);
            return cipherText;
        }
        catch (Exception exception) {
            throw new SecretRuntimeException(exception);
        }
    }

    public static byte[] encryptEcbPadding(byte[] data, byte[] key) {
        try {
            Cipher cipher = Sm4Util.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 1, key);
            return cipher.doFinal(data);
        }
        catch (Exception exception) {
            throw new SecretRuntimeException(exception);
        }
    }

    public static String decryptEcb(String cipherText, String hexKey) {
        try {
            String decryptStr = "";
            byte[] keyData = ByteUtils.fromHexString((String)hexKey);
            byte[] cipherData = ByteUtils.fromHexString((String)cipherText);
            byte[] srcData = Sm4Util.decryptEcbPadding(keyData, cipherData);
            decryptStr = new String(srcData, ENCODING);
            return decryptStr;
        }
        catch (Exception exception) {
            throw new SecretRuntimeException(exception);
        }
    }

    public static byte[] decryptEcbPadding(byte[] cipherText, byte[] key) {
        try {
            Cipher cipher = Sm4Util.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 2, key);
            return cipher.doFinal(cipherText);
        }
        catch (Exception exception) {
            throw new SecretRuntimeException(exception);
        }
    }

    public static boolean verifyEcb(String hexKey, String cipherText, String plainText) {
        try {
            boolean flag = false;
            byte[] keyData = ByteUtils.fromHexString((String)hexKey);
            byte[] cipherData = ByteUtils.fromHexString((String)cipherText);
            byte[] decryptData = Sm4Util.decryptEcbPadding(keyData, cipherData);
            byte[] srcData = plainText.getBytes(ENCODING);
            flag = Arrays.equals(decryptData, srcData);
            return flag;
        }
        catch (Exception exception) {
            throw new SecretRuntimeException(exception);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

