/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.support.secret.core.secret;

import com.taotao.boot.common.support.secret.api.ISecretContext;
import com.taotao.boot.common.support.secret.core.RsaUtil;
import com.taotao.boot.common.support.secret.core.secret.AbstractSecret;
import com.taotao.boot.common.support.secret.exception.SecretRuntimeException;
import java.io.UnsupportedEncodingException;

public class RsaSecret
extends AbstractSecret {
    @Override
    protected byte[] doEncrypt(ISecretContext context) {
        try {
            String key = context.keyText();
            return RsaUtil.encrypt(context.source(), key).getBytes(context.charset());
        }
        catch (UnsupportedEncodingException e) {
            throw new SecretRuntimeException(e);
        }
    }

    @Override
    protected byte[] doDecrypt(ISecretContext context) {
        try {
            String key = context.keyText();
            return RsaUtil.decrypt(context.sourceText(), key).getBytes(context.charset());
        }
        catch (UnsupportedEncodingException e) {
            throw new SecretRuntimeException(e);
        }
    }
}

