/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.support.thread;

import com.taotao.boot.common.utils.servlet.MdcUtils;
import java.util.Map;
import org.springframework.core.task.TaskDecorator;

public class MDCTaskDecorator
implements TaskDecorator {
    public Runnable decorate(Runnable runnable) {
        try {
            Map<String, String> previous = MdcUtils.getCopyOfContextMap();
            return () -> {
                try {
                    MdcUtils.setContextMap(previous);
                    runnable.run();
                }
                finally {
                    MdcUtils.clear();
                }
            };
        }
        catch (IllegalStateException e) {
            return runnable;
        }
    }
}

