/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.utils.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.collect.Lists;
import com.taotao.boot.common.exception.BaseException;
import com.taotao.boot.common.support.function.CheckedConsumer;
import com.taotao.boot.common.support.json.JacksonModule;
import com.taotao.boot.common.support.json.MyBeanSerializerModifier;
import com.taotao.boot.common.utils.collection.CollectionUtils;
import com.taotao.boot.common.utils.exception.ExceptionUtils;
import com.taotao.boot.common.utils.io.FileUtils;
import com.taotao.boot.common.utils.lang.ObjectUtils;
import com.taotao.boot.common.utils.lang.StringUtils;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.TimeZone;
import org.dromara.hutool.core.text.StrUtil;

public final class JsonUtils {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    private JsonUtils() {
    }

    public static String toJSONString(Object object) {
        return JsonUtils.toJSONString(object, false);
    }

    public static String toJSONString(Object object, boolean format) {
        try {
            if (object == null) {
                return "";
            }
            if (object instanceof Number) {
                return object.toString();
            }
            if (object instanceof String) {
                return (String)object;
            }
            if (format) {
                return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(object);
            }
            return MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new BaseException(e.getMessage());
        }
    }

    public static <T> T toObject(String json, Class<T> cls) {
        if (StrUtil.isBlank((CharSequence)json) || cls == null) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(json, cls);
        }
        catch (IOException e) {
            throw new BaseException(e);
        }
    }

    public static <T> T toObject(String json, Class<?> parametrized, Class<?> ... parameterClasses) {
        if (StrUtil.isBlank((CharSequence)json) || parametrized == null) {
            return null;
        }
        try {
            JavaType javaType = MAPPER.getTypeFactory().constructParametricType(parametrized, (Class[])parameterClasses);
            return (T)MAPPER.readValue(json, javaType);
        }
        catch (IOException e) {
            throw new BaseException(e);
        }
    }

    public static <T> T toObject(String json, TypeReference<T> typeReference) {
        if (StrUtil.isBlank((CharSequence)json) || typeReference == null) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(json, typeReference);
        }
        catch (IOException e) {
            throw new BaseException(e);
        }
    }

    public static JsonNode parse(String json) {
        if (StrUtil.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return MAPPER.readTree(json);
        }
        catch (IOException e) {
            throw new BaseException(e);
        }
    }

    public static <K, V> Map<K, V> toMap(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return JsonUtils.toObject((String)object, Map.class);
        }
        return (Map)MAPPER.convertValue(object, Map.class);
    }

    public static <T> List<T> toList(String json) {
        if (StrUtil.isNotBlank((CharSequence)json)) {
            try {
                return (List)MAPPER.readValue(json, List.class);
            }
            catch (JsonProcessingException e) {
                throw new BaseException(e.getMessage());
            }
        }
        return new ArrayList();
    }

    public static <T> List<T> toList(String json, Class<T> cls) {
        if (StrUtil.isBlank((CharSequence)json)) {
            return new ArrayList();
        }
        try {
            JavaType javaType = MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{cls});
            return (List)MAPPER.readValue(json, javaType);
        }
        catch (JsonProcessingException e) {
            throw new BaseException(e.getMessage());
        }
    }

    @Nullable
    public static String toJson(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        try {
            return MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static byte[] toJsonAsBytes(@Nullable Object object) {
        if (object == null) {
            return new byte[0];
        }
        try {
            return MAPPER.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static JsonNode readTree(String jsonString) {
        Objects.requireNonNull(jsonString, "jsonString is null");
        try {
            return MAPPER.readTree(jsonString);
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static JsonNode readTree(InputStream in) {
        Objects.requireNonNull(in, "InputStream in is null");
        try {
            return MAPPER.readTree(in);
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static JsonNode readTree(byte[] content) {
        Objects.requireNonNull(content, "byte[] content is null");
        try {
            return MAPPER.readTree(content);
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static JsonNode readTree(JsonParser jsonParser) {
        Objects.requireNonNull(jsonParser, "jsonParser is null");
        try {
            return (JsonNode)MAPPER.readTree(jsonParser);
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable byte[] content, Class<T> valueType) {
        if (ObjectUtils.isEmpty(content)) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(content, valueType);
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable String jsonString, Class<T> valueType) {
        if (StringUtils.isBlank(jsonString)) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(jsonString, valueType);
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable InputStream in, Class<T> valueType) {
        if (in == null) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(in, valueType);
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable byte[] content, TypeReference<T> typeReference) {
        if (ObjectUtils.isEmpty(content)) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(content, typeReference);
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable String jsonString, TypeReference<T> typeReference) {
        if (StringUtils.isBlank(jsonString)) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(jsonString, typeReference);
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable InputStream in, TypeReference<T> typeReference) {
        if (in == null) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(in, typeReference);
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable byte[] content, JavaType javaType) {
        if (ObjectUtils.isEmpty(content)) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(content, javaType);
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable String jsonString, JavaType javaType) {
        if (StringUtils.isBlank(jsonString)) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(jsonString, javaType);
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable InputStream in, JavaType javaType) {
        if (in == null) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(in, javaType);
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static MapType getMapType(Class<?> valueClass) {
        return JsonUtils.getMapType(String.class, valueClass);
    }

    public static MapType getMapType(Class<?> keyClass, Class<?> valueClass) {
        return MAPPER.getTypeFactory().constructMapType(Map.class, keyClass, valueClass);
    }

    public static CollectionLikeType getListType(Class<?> elementClass) {
        return MAPPER.getTypeFactory().constructCollectionLikeType(List.class, elementClass);
    }

    public static JavaType getParametricType(Class<?> parametrized, Class<?> ... parameterClasses) {
        return MAPPER.getTypeFactory().constructParametricType(parametrized, (Class[])parameterClasses);
    }

    public static <T> List<T> readList(@Nullable byte[] content, Class<T> elementClass) {
        if (ObjectUtils.isEmpty(content)) {
            return Collections.emptyList();
        }
        try {
            return (List)MAPPER.readValue(content, (JavaType)JsonUtils.getListType(elementClass));
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static <T> List<T> readList(@Nullable InputStream content, Class<T> elementClass) {
        if (content == null) {
            return Collections.emptyList();
        }
        try {
            return (List)MAPPER.readValue(content, (JavaType)JsonUtils.getListType(elementClass));
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static <T> List<T> readList(@Nullable String content, Class<T> elementClass) {
        if (ObjectUtils.isEmpty(content)) {
            return Collections.emptyList();
        }
        try {
            return (List)MAPPER.readValue(content, (JavaType)JsonUtils.getListType(elementClass));
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static Map<String, Object> readMap(@Nullable byte[] content) {
        return JsonUtils.readMap(content, Object.class);
    }

    public static Map<String, Object> readMap(@Nullable InputStream content) {
        return JsonUtils.readMap(content, Object.class);
    }

    public static Map<String, Object> readMap(@Nullable String content) {
        return JsonUtils.readMap(content, Object.class);
    }

    public static <V> Map<String, V> readMap(@Nullable byte[] content, Class<?> valueClass) {
        return JsonUtils.readMap(content, String.class, valueClass);
    }

    public static <V> Map<String, V> readMap(@Nullable InputStream content, Class<?> valueClass) {
        return JsonUtils.readMap(content, String.class, valueClass);
    }

    public static <V> Map<String, V> readMap(@Nullable String content, Class<?> valueClass) {
        return JsonUtils.readMap(content, String.class, valueClass);
    }

    public static <K, V> Map<K, V> readMap(@Nullable byte[] content, Class<?> keyClass, Class<?> valueClass) {
        if (ObjectUtils.isEmpty(content)) {
            return Collections.emptyMap();
        }
        try {
            return (Map)MAPPER.readValue(content, (JavaType)JsonUtils.getMapType(keyClass, valueClass));
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static <K, V> Map<K, V> readMap(@Nullable InputStream content, Class<?> keyClass, Class<?> valueClass) {
        if (ObjectUtils.isEmpty(content)) {
            return Collections.emptyMap();
        }
        try {
            return (Map)MAPPER.readValue(content, (JavaType)JsonUtils.getMapType(keyClass, valueClass));
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static <K, V> Map<K, V> readMap(@Nullable String content, Class<?> keyClass, Class<?> valueClass) {
        if (ObjectUtils.isEmpty(content)) {
            return Collections.emptyMap();
        }
        try {
            return (Map)MAPPER.readValue(content, (JavaType)JsonUtils.getMapType(keyClass, valueClass));
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)MAPPER.convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, JavaType toValueType) {
        return (T)MAPPER.convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        return (T)MAPPER.convertValue(fromValue, toValueTypeRef);
    }

    public static <T> T treeToValue(TreeNode treeNode, Class<T> valueType) {
        try {
            return (T)MAPPER.treeToValue(treeNode, valueType);
        }
        catch (JsonProcessingException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static <T extends JsonNode> T valueToTree(@Nullable Object fromValue) {
        return (T)MAPPER.valueToTree(fromValue);
    }

    public static boolean canSerialize(@Nullable Object value) {
        if (value == null) {
            return true;
        }
        return MAPPER.canSerialize(value.getClass());
    }

    public static boolean canDeserialize(JavaType type) {
        return MAPPER.canDeserialize(type);
    }

    public static boolean isValidJson(String jsonString) {
        return JsonUtils.isValidJson((ObjectMapper mapper) -> mapper.readTree(jsonString));
    }

    public static boolean isValidJson(byte[] content) {
        return JsonUtils.isValidJson((ObjectMapper mapper) -> mapper.readTree(content));
    }

    public static boolean isValidJson(InputStream input) {
        return JsonUtils.isValidJson((ObjectMapper mapper) -> mapper.readTree(input));
    }

    public static boolean isValidJson(JsonParser jsonParser) {
        return JsonUtils.isValidJson((ObjectMapper mapper) -> mapper.readTree(jsonParser));
    }

    public static boolean isValidJson(CheckedConsumer<ObjectMapper> consumer) {
        ObjectMapper mapper = MAPPER.copy();
        mapper.enable(DeserializationFeature.FAIL_ON_TRAILING_TOKENS);
        mapper.enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY);
        try {
            consumer.accept(mapper);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static ObjectNode createObjectNode() {
        return MAPPER.createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return MAPPER.createArrayNode();
    }

    public static List<String> getIndexList(String compressJsonPath, int size) {
        String json = FileUtils.getFileContent(compressJsonPath);
        if (StringUtils.isEmptyTrim(json) || size <= 0) {
            return Collections.emptyList();
        }
        List<Integer> prefixList = CollectionUtils.fill(size);
        return JsonUtils.getIndexList(compressJsonPath, prefixList);
    }

    public static List<String> getIndexList(String compressJsonPath, List<?> indexPrefixList) {
        int i;
        String json = FileUtils.getFileContent(compressJsonPath);
        if (StringUtils.isEmptyTrim(json) || CollectionUtils.isEmpty(indexPrefixList)) {
            return Collections.emptyList();
        }
        ArrayList results = Lists.newArrayList();
        Stack<Integer> stack = new Stack<Integer>();
        ArrayList indexList = Lists.newArrayList();
        for (i = 0; i < json.length(); ++i) {
            char ch = json.charAt(i);
            if ('{' == ch) {
                stack.push(i);
            }
            if ('}' != ch) continue;
            Integer startIndex = (Integer)stack.pop();
            int endIndex = i + 1;
            int byteStartIndex = json.substring(0, startIndex).getBytes().length;
            int byteEndIndex = byteStartIndex + json.substring(startIndex, endIndex).getBytes().length;
            String result = byteStartIndex + "," + byteEndIndex;
            indexList.add(result);
        }
        for (i = 0; i < indexPrefixList.size(); ++i) {
            String prefix = JsonUtils.getPrefix(indexPrefixList.get(i));
            String result = prefix + (String)indexList.get(i);
            results.add(result);
        }
        return results;
    }

    private static String getPrefix(Object object) {
        if (ObjectUtils.isNull(object)) {
            return "";
        }
        String string = object.toString();
        if (StringUtils.isEmptyTrim(string)) {
            return "";
        }
        return string + " ";
    }

    static {
        MAPPER.findAndRegisterModules();
        MAPPER.setLocale(Locale.CHINA);
        MAPPER.setTimeZone(TimeZone.getTimeZone(ZoneId.systemDefault()));
        MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.configure(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES.mappedFeature(), true);
        MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        MAPPER.configure(JsonReadFeature.ALLOW_LEADING_ZEROS_FOR_NUMBERS.mappedFeature(), true);
        MAPPER.configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true);
        MAPPER.configure(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER.mappedFeature(), true);
        MAPPER.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        MAPPER.setPropertyNamingStrategy(PropertyNamingStrategies.LOWER_CAMEL_CASE);
        MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA));
        MAPPER.setSerializerFactory(MAPPER.getSerializerFactory().withSerializerModifier((BeanSerializerModifier)new MyBeanSerializerModifier()));
        MAPPER.registerModule((Module)new Jdk8Module());
        MAPPER.registerModule((Module)new JacksonModule());
    }
}

