/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.utils.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public final class ImageUtils {
    private ImageUtils() {
    }

    public static BufferedImage zoomOut(BufferedImage src, int maxSize, ResizeMode resizeMode, boolean forceZoom) {
        int width = src.getWidth();
        int height = src.getHeight();
        int newWidth = 0;
        int newHeight = 0;
        boolean resize = false;
        if (resizeMode == ResizeMode.AUTO) {
            resizeMode = width >= height ? ResizeMode.FIX_WIDTH : ResizeMode.FIX_HEIGHT;
        }
        if (resizeMode == ResizeMode.FIX_WIDTH) {
            if (width > maxSize || forceZoom) {
                newWidth = maxSize;
                newHeight = Math.toIntExact((long)maxSize * (long)height / (long)width);
                resize = true;
            }
        } else if (resizeMode == ResizeMode.FIX_HEIGHT && (height > maxSize || forceZoom)) {
            newHeight = maxSize;
            newWidth = Math.toIntExact((long)maxSize * (long)width / (long)height);
            resize = true;
        }
        if (!resize) {
            return src;
        }
        BufferedImage newImage = new BufferedImage(newWidth, newHeight, 1);
        newImage.getGraphics().drawImage(src.getScaledInstance(newWidth, newHeight, 1), 0, 0, null);
        return newImage;
    }

    public static byte[] zoomOut(InputStream in, int maxSize, ResizeMode resizeMode, boolean forceZoom) throws IOException {
        BufferedImage dist = ImageUtils.zoomOut(ImageIO.read(in), maxSize, resizeMode, forceZoom);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)dist, "jpg", out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static byte[] zoomOut(byte[] bytes, int maxSize, ResizeMode resizeMode, boolean forceZoom) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            byte[] byArray = ImageUtils.zoomOut(in, maxSize, resizeMode, forceZoom);
            return byArray;
        }
    }

    public static enum ResizeMode {
        FIX_WIDTH,
        FIX_HEIGHT,
        AUTO;

    }
}

