/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.utils.servlet;

import com.taotao.boot.common.utils.servlet.MdcUtils;
import jakarta.servlet.http.HttpServletRequest;
import org.dromara.hutool.core.text.StrUtil;

public class TraceUtils {
    private TraceUtils() {
    }

    public static String getTtcTraceIdByRequest(HttpServletRequest request) {
        String traceId = request.getParameter("ttc-trace-id");
        if (StrUtil.isBlank((CharSequence)traceId)) {
            traceId = request.getHeader("ttc-trace-id");
        }
        return traceId;
    }

    public static String getTtcTraceId() {
        return MdcUtils.get("ttc-trace-id");
    }

    public static void setTtcTraceId(String traceId) {
        MdcUtils.put("ttc-trace-id", traceId);
    }

    public static void removeTtcTraceId() {
        MdcUtils.remove("ttc-trace-id");
    }

    public static void setTtcTenantId(String tenantId) {
        MdcUtils.put("ttc-tenant-id", tenantId);
    }

    public static void removeTtcTenantId() {
        MdcUtils.remove("ttc-tenant-id");
    }

    public static String getTtcTenantId() {
        return MdcUtils.get("ttc-tenant-id");
    }

    public static void setTtcVersion(String version) {
        MdcUtils.put("ttc-request-version", version);
    }

    public static void removeTtcVersion() {
        MdcUtils.remove("ttc-request-version");
    }

    public static String getTtcVersion() {
        return MdcUtils.get("ttc-request-version");
    }

    public static String getZipkinTraceIdByRequest(HttpServletRequest request) {
        String zipkinTraceId = request.getParameter("X-B3-TraceId");
        if (StrUtil.isBlank((CharSequence)zipkinTraceId)) {
            zipkinTraceId = request.getHeader("X-B3-TraceId");
        }
        return zipkinTraceId;
    }

    public static String getZipkinSpanIdByRequest(HttpServletRequest request) {
        String zipkinSpanId = request.getParameter("X-B3-SpanId");
        if (StrUtil.isBlank((CharSequence)zipkinSpanId)) {
            zipkinSpanId = request.getHeader("X-B3-SpanId");
        }
        return zipkinSpanId;
    }

    public static void setZipkinTraceId(HttpServletRequest request) {
        String zipkinTraceId = TraceUtils.getZipkinTraceIdByRequest(request);
        MdcUtils.put("X-B3-TraceId", zipkinTraceId);
    }

    public static void setZipkinTraceId(String zipkinTraceId) {
        MdcUtils.put("X-B3-TraceId", zipkinTraceId);
    }

    public static void removeZipkinTraceId() {
        MdcUtils.remove("X-B3-TraceId");
    }

    public static String getZipkinTraceId() {
        return MdcUtils.get("X-B3-TraceId");
    }

    public static void setZipkinSpanId(HttpServletRequest request) {
        String zipkinSpanId = TraceUtils.getZipkinSpanIdByRequest(request);
        MdcUtils.put("X-B3-SpanId", zipkinSpanId);
    }

    public static void setZipkinSpanId(String zipkinSpanId) {
        MdcUtils.put("X-B3-SpanId", zipkinSpanId);
    }

    public static void removeZipkinSpanId() {
        MdcUtils.remove("X-B3-SpanId");
    }

    public static String getZipkinSpanId() {
        return MdcUtils.get("X-B3-SpanId");
    }

    public static String getTraceIdByRequest(HttpServletRequest request) {
        String traceId = request.getParameter("traceId");
        if (StrUtil.isBlank((CharSequence)traceId)) {
            traceId = request.getHeader("traceId");
        }
        return traceId;
    }

    public static String getTraceId() {
        return MdcUtils.get("traceId");
    }

    public static void setTraceId(String traceId) {
        MdcUtils.put("traceId", traceId);
    }

    public static void removeTraceId() {
        MdcUtils.remove("traceId");
    }

    public static String getSpanIdByRequest(HttpServletRequest request) {
        String spanId = request.getParameter("spanId");
        if (StrUtil.isBlank((CharSequence)spanId)) {
            spanId = request.getHeader("spanId");
        }
        return spanId;
    }

    public static String getSpanId() {
        return MdcUtils.get("spanId");
    }

    public static void setSpanId(String spanId) {
        MdcUtils.put("spanId", spanId);
    }

    public static void removeSpanId() {
        MdcUtils.remove("spanId");
    }
}

