/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.utils.validator;

import com.taotao.boot.common.enums.ValidatorExceptionEnum;
import com.taotao.boot.common.exception.ParamValidateException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.Iterator;
import java.util.Set;
import org.dromara.hutool.core.text.StrUtil;

public class ValidatorUtils {
    private static final Validator VALIDATOR_INSTANCE = Validation.buildDefaultValidatorFactory().getValidator();

    public static <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        return VALIDATOR_INSTANCE.validate(object, (Class[])groups);
    }

    public static boolean simpleValidate(Object object, Class<?> ... groups) {
        Set constraintViolations = VALIDATOR_INSTANCE.validate(object, (Class[])groups);
        return constraintViolations.isEmpty();
    }

    public static void validateThrowMessage(Object object, Class<?> ... groups) {
        String errorMessage = ValidatorUtils.validateGetMessage(object, groups);
        if (errorMessage != null) {
            throw new ParamValidateException(ValidatorExceptionEnum.VALIDATED_RESULT_ERROR.getDesc());
        }
    }

    public static String validateGetMessage(Object object, Class<?> ... groups) {
        Set constraintViolations = VALIDATOR_INSTANCE.validate(object, (Class[])groups);
        if (!constraintViolations.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder();
            Iterator it = constraintViolations.iterator();
            while (it.hasNext()) {
                ConstraintViolation violation = (ConstraintViolation)it.next();
                errorMessage.append(violation.getMessage());
                if (!it.hasNext()) continue;
                errorMessage.append(", ");
            }
            return StrUtil.format((CharSequence)ValidatorExceptionEnum.VALIDATED_RESULT_ERROR.getUserTip(), (Object[])new Object[0]);
        }
        return null;
    }
}

