/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.configuration;

import com.taotao.boot.data.datasource.properties.DataSourceProperties;
import com.zaxxer.hikari.HikariDataSource;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.boot.jdbc.metadata.HikariDataSourcePoolMetadata;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={DataSourceProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.data.datasource", name={"healthEnabled"}, havingValue="true")
public class DataSourceHealthAutoConfiguration {
    @Bean
    DataSourcePoolMetadataProvider dataSourcePoolMetadataProvider() {
        return dataSource -> dataSource instanceof HikariDataSource ? new HikariDataSourcePoolMetadata((HikariDataSource)dataSource) : new NotAvailableDataSourcePoolMetadata();
    }

    private static class NotAvailableDataSourcePoolMetadata
    implements DataSourcePoolMetadata {
        private NotAvailableDataSourcePoolMetadata() {
        }

        public Float getUsage() {
            return null;
        }

        public Integer getActive() {
            return null;
        }

        public Integer getMax() {
            return null;
        }

        public Integer getMin() {
            return null;
        }

        public String getValidationQuery() {
            return "select 1";
        }

        public Boolean getDefaultAutoCommit() {
            return null;
        }
    }
}

