/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.configuration;

import com.baomidou.dynamic.datasource.processor.DsJakartaHeaderProcessor;
import com.baomidou.dynamic.datasource.processor.DsJakartaSessionProcessor;
import com.baomidou.dynamic.datasource.processor.DsProcessor;
import com.baomidou.dynamic.datasource.processor.DsSpelExpressionProcessor;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.datasource.dynamic.mybatisplus.config.DsLastParamProcessor;
import com.taotao.boot.data.datasource.dynamic.mybatisplus.config.JdbcDynamicDataSourceProvider;
import com.taotao.boot.data.datasource.dynamic.mybatisplus.properties.DynamicDataSourceProperties;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@EnableConfigurationProperties(value={DynamicDataSourceProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.data.datasource.dynamic", name={"enabled"}, havingValue="true")
public class DynamicDataSourceAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(DynamicDataSourceAutoConfiguration.class, (String)"taotao-boot-starter-datasource", (String[])new String[0]);
    }

    @Bean
    public DynamicDataSourceProvider dynamicDataSourceProvider(StringEncryptor stringEncryptor, DataSourceProperties properties, DynamicDataSourceProperties dynamicDataSourceProperties) {
        return new JdbcDynamicDataSourceProvider(stringEncryptor, properties, dynamicDataSourceProperties);
    }

    @Bean
    public DsProcessor dsProcessor() {
        DsLastParamProcessor lastParamProcessor = new DsLastParamProcessor();
        DsJakartaHeaderProcessor headerProcessor = new DsJakartaHeaderProcessor();
        DsJakartaSessionProcessor sessionProcessor = new DsJakartaSessionProcessor();
        DsSpelExpressionProcessor spelExpressionProcessor = new DsSpelExpressionProcessor();
        lastParamProcessor.setNextProcessor((DsProcessor)headerProcessor);
        headerProcessor.setNextProcessor((DsProcessor)sessionProcessor);
        sessionProcessor.setNextProcessor((DsProcessor)spelExpressionProcessor);
        return lastParamProcessor;
    }
}

