/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.configuration;

import com.taotao.boot.data.datasource.configuration.TransactionExecutorAutoConfiguration;
import com.taotao.boot.data.datasource.tx.TxWrapper;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Import;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;

@AutoConfiguration(after={TransactionExecutorAutoConfiguration.class})
@Import(value={TxWrapper.class})
public class TransactionAutoConfiguration {
    private final PlatformTransactionManager platformTransactionManager;
    private final TransactionDefinition transactionDefinition;
    private final ThreadPoolExecutor threadPoolExecutor;

    public TransactionAutoConfiguration(PlatformTransactionManager platformTransactionManager, TransactionDefinition transactionDefinition, @Autowired @Qualifier(value="transactionThreadPoolExecutor") ThreadPoolExecutor threadPoolExecutor) {
        this.platformTransactionManager = platformTransactionManager;
        this.transactionDefinition = transactionDefinition;
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public void execute(Task task) {
        TransactionStatus transactionStatus = this.platformTransactionManager.getTransaction(this.transactionDefinition);
        try {
            task.run();
            this.platformTransactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            this.platformTransactionManager.rollback(transactionStatus);
            throw new RuntimeException("");
        }
    }

    public <T> Optional<T> execute(Supplier<T> supplier) {
        TransactionStatus transactionStatus = this.platformTransactionManager.getTransaction(this.transactionDefinition);
        Object t = null;
        try {
            t = supplier.get();
            this.platformTransactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            this.platformTransactionManager.rollback(transactionStatus);
            throw new RuntimeException("");
        }
        return Optional.ofNullable(t);
    }

    public void asyncExecute(Task task) {
        this.threadPoolExecutor.execute(() -> {
            TransactionStatus transactionStatus = this.platformTransactionManager.getTransaction(this.transactionDefinition);
            try {
                task.run();
                this.platformTransactionManager.commit(transactionStatus);
            }
            catch (Exception e) {
                this.platformTransactionManager.rollback(transactionStatus);
            }
        });
    }

    public <T> Optional<T> asyncExecute(Supplier<T> supplier) {
        Future<Object> future = this.threadPoolExecutor.submit(() -> {
            TransactionStatus transactionStatus = this.platformTransactionManager.getTransaction(this.transactionDefinition);
            Object t = null;
            try {
                t = supplier.get();
                this.platformTransactionManager.commit(transactionStatus);
            }
            catch (Exception e) {
                this.platformTransactionManager.rollback(transactionStatus);
            }
            return t;
        });
        Object t = null;
        try {
            t = future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Optional.ofNullable(t);
    }

    @FunctionalInterface
    public static interface Task {
        public void run();
    }
}

