/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.druid;

import com.alibaba.druid.spring.boot3.autoconfigure.DruidDataSourceAutoConfigure;
import com.alibaba.druid.spring.boot3.autoconfigure.properties.DruidStatProperties;
import com.alibaba.druid.util.Utils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={DruidDataSourceAutoConfigure.class})
public class DruidRemoveAdConfiguartion {
    private static final String FILE_PATH = "support/http/resources/js/common.js";
    private static final String ORIGIN_JS = "this.buildFooter();";
    private static final String NEW_JS = "//this.buildFooter();";

    @Bean
    @ConditionalOnWebApplication
    @ConditionalOnProperty(name={"spring.datasource.druid.stat-view-servlet.enabled"}, havingValue="true")
    public FilterRegistrationBean<RemoveAdFilter> removeDruidAdFilter(DruidStatProperties properties) throws IOException {
        DruidStatProperties.StatViewServlet config = properties.getStatViewServlet();
        String pattern = config.getUrlPattern() != null ? config.getUrlPattern() : "/druid/*";
        String commonJsPattern = pattern.replaceAll("\\*", "js/common.js");
        String text = Utils.readFromResource((String)FILE_PATH);
        String newJs = text.replace(ORIGIN_JS, NEW_JS);
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new RemoveAdFilter(newJs));
        registration.addUrlPatterns(new String[]{commonJsPattern});
        return registration;
    }

    private static class RemoveAdFilter
    implements Filter {
        private final String newJs;

        public RemoveAdFilter(String newJs) {
            this.newJs = newJs;
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            chain.doFilter(request, response);
            response.resetBuffer();
            response.getWriter().write(this.newJs);
        }
    }
}

