/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.druid;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.stat.DruidStatManagerFacade;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/druid"})
public class DruidStatController {
    @Resource
    private DataSource dataSource;

    @GetMapping(value={"/stat"})
    public List<Map<String, Object>> druidStat() {
        return DruidStatManagerFacade.getInstance().getDataSourceStatDataList();
    }

    @GetMapping(value={"/druidDataSource"})
    public Map<String, Object> druidDataSource() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("class", this.dataSource.getClass());
        if (this.dataSource instanceof DruidDataSource) {
            DruidDataSource druidDataSource = (DruidDataSource)this.dataSource;
            dataMap.put("version", druidDataSource.getVersion());
            dataMap.put("name", druidDataSource.getName());
            dataMap.put("initialSize", druidDataSource.getInitialSize());
            dataMap.put("maxActive", druidDataSource.getMaxActive());
            dataMap.put("minIdle", druidDataSource.getMinIdle());
            dataMap.put("activeCount", druidDataSource.getActiveCount());
            dataMap.put("activePeak", druidDataSource.getActivePeak());
            dataMap.put("activePeakTime", druidDataSource.getActivePeakTime());
            dataMap.put("poolingCount", druidDataSource.getPoolingCount());
            dataMap.put("poolingPeak", druidDataSource.getPoolingPeak());
            dataMap.put("poolingPeakTime", druidDataSource.getPoolingPeakTime());
        }
        return dataMap;
    }
}

