/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.druid;

import com.alibaba.druid.pool.DruidDataSourceStatLogger;
import com.alibaba.druid.pool.DruidDataSourceStatLoggerAdapter;
import com.alibaba.druid.pool.DruidDataSourceStatLoggerImpl;
import com.alibaba.druid.pool.DruidDataSourceStatValue;
import com.alibaba.druid.stat.JdbcSqlStatValue;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;

public class DruidStatLogger
extends DruidDataSourceStatLoggerAdapter
implements DruidDataSourceStatLogger {
    private static final Log LOG = LogFactory.getLog(DruidDataSourceStatLoggerImpl.class);
    private Log logger = LOG;

    public DruidStatLogger() {
        this.configFromProperties(System.getProperties());
    }

    public boolean isLogEnable() {
        return this.logger.isInfoEnabled();
    }

    public void log(String value) {
        this.logger.info(value);
    }

    public void log(DruidDataSourceStatValue druidDataSourceStatValue) {
        if (!this.isLogEnable()) {
            return;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("dbType", druidDataSourceStatValue.getDbType());
        map.put("name", druidDataSourceStatValue.getName());
        map.put("activeCount", druidDataSourceStatValue.getActiveCount());
        if (druidDataSourceStatValue.getActivePeak() > 0) {
            map.put("activePeak", druidDataSourceStatValue.getActivePeak());
            map.put("activePeakTime", druidDataSourceStatValue.getActivePeakTime());
        }
        map.put("poolingCount", druidDataSourceStatValue.getPoolingCount());
        if (druidDataSourceStatValue.getPoolingPeak() > 0) {
            map.put("poolingPeak", druidDataSourceStatValue.getPoolingPeak());
            map.put("poolingPeakTime", druidDataSourceStatValue.getPoolingPeakTime());
        }
        map.put("connectCount", druidDataSourceStatValue.getConnectCount());
        map.put("closeCount", druidDataSourceStatValue.getCloseCount());
        if (druidDataSourceStatValue.getWaitThreadCount() > 0L) {
            map.put("waitThreadCount", druidDataSourceStatValue.getWaitThreadCount());
        }
        if (druidDataSourceStatValue.getNotEmptyWaitCount() > 0L) {
            map.put("notEmptyWaitCount", druidDataSourceStatValue.getNotEmptyWaitCount());
        }
        if (druidDataSourceStatValue.getNotEmptyWaitMillis() > 0L) {
            map.put("notEmptyWaitMillis", druidDataSourceStatValue.getNotEmptyWaitMillis());
        }
        if (druidDataSourceStatValue.getLogicConnectErrorCount() > 0L) {
            map.put("logicConnectErrorCount", druidDataSourceStatValue.getLogicConnectErrorCount());
        }
        if (druidDataSourceStatValue.getPhysicalConnectCount() > 0L) {
            map.put("physicalConnectCount", druidDataSourceStatValue.getPhysicalConnectCount());
        }
        if (druidDataSourceStatValue.getPhysicalCloseCount() > 0L) {
            map.put("physicalCloseCount", druidDataSourceStatValue.getPhysicalCloseCount());
        }
        if (druidDataSourceStatValue.getPhysicalConnectErrorCount() > 0L) {
            map.put("physicalConnectErrorCount", druidDataSourceStatValue.getPhysicalConnectErrorCount());
        }
        if (druidDataSourceStatValue.getExecuteCount() > 0L) {
            map.put("executeCount", druidDataSourceStatValue.getExecuteCount());
        }
        if (druidDataSourceStatValue.getErrorCount() > 0L) {
            map.put("errorCount", druidDataSourceStatValue.getErrorCount());
        }
        if (druidDataSourceStatValue.getCommitCount() > 0L) {
            map.put("commitCount", druidDataSourceStatValue.getCommitCount());
        }
        if (druidDataSourceStatValue.getRollbackCount() > 0L) {
            map.put("rollbackCount", druidDataSourceStatValue.getRollbackCount());
        }
        if (druidDataSourceStatValue.getPstmtCacheHitCount() > 0L) {
            map.put("pstmtCacheHitCount", druidDataSourceStatValue.getPstmtCacheHitCount());
        }
        if (druidDataSourceStatValue.getPstmtCacheMissCount() > 0L) {
            map.put("pstmtCacheMissCount", druidDataSourceStatValue.getPstmtCacheMissCount());
        }
        if (druidDataSourceStatValue.getStartTransactionCount() > 0L) {
            map.put("startTransactionCount", druidDataSourceStatValue.getStartTransactionCount());
            map.put("transactionHistogram", druidDataSourceStatValue.getTransactionHistogram());
        }
        if (druidDataSourceStatValue.getConnectCount() > 0L) {
            map.put("connectionHoldTimeHistogram", druidDataSourceStatValue.getConnectionHoldTimeHistogram());
        }
        if (druidDataSourceStatValue.getClobOpenCount() > 0L) {
            map.put("clobOpenCount", druidDataSourceStatValue.getClobOpenCount());
        }
        if (druidDataSourceStatValue.getBlobOpenCount() > 0L) {
            map.put("blobOpenCount", druidDataSourceStatValue.getBlobOpenCount());
        }
        if (druidDataSourceStatValue.getSqlSkipCount() > 0L) {
            map.put("sqlSkipCount", druidDataSourceStatValue.getSqlSkipCount());
        }
        if (!this.isLogEnable()) {
            return;
        }
        myArrayList sqlList = new myArrayList();
        if (druidDataSourceStatValue.getSqlList().size() > 0) {
            for (JdbcSqlStatValue sqlStat : druidDataSourceStatValue.getSqlList()) {
                LinkedHashMap<String, String> sqlStatMap = new LinkedHashMap<String, String>();
                sqlStatMap.put("\u6267\u884c\u4e86sql\u8bed\u53e5\uff1a ", sqlStat.getSql());
                sqlList.add(sqlStatMap);
                String string = sqlList.toString();
            }
        } else {
            String text = ((Object)map).toString();
            this.log(text);
        }
    }

    public void configFromProperties(Properties properties) {
        String property = properties.getProperty("druid.stat.loggerName");
        if (property != null && property.length() > 0) {
            this.setLoggerName(property);
        }
    }

    public void setLogger(Log log) {
        if (log == null) {
            throw new IllegalArgumentException("logger can not be null");
        }
        this.logger = log;
    }

    public void setLoggerName(String loggerName) {
        this.logger = LogFactory.getLog((String)loggerName);
    }

    class myArrayList<E>
    extends ArrayList<E> {
        myArrayList() {
        }

        @Override
        public String toString() {
            Iterator it = this.iterator();
            if (!it.hasNext()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            while (true) {
                Object e;
                sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
                if (!it.hasNext()) {
                    return sb.toString();
                }
                sb.append(',').append(' ');
            }
        }
    }
}

