/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.druid;

import com.alibaba.druid.util.DruidPasswordCallback;
import com.alibaba.fastjson2.JSONObject;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.datasource.utils.RSAUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.stream.Collectors;
import org.springframework.core.io.ResourceLoader;

public class RsaDBPasswordCallBack
extends DruidPasswordCallback {
    private final ResourceLoader resourceLoader;
    private static final String RSA_KEYS_FILE_PATH = "classpath:/druid/rsa/rsa_keys.txt";

    public RsaDBPasswordCallBack(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setProperties(Properties properties) {
        super.setProperties(properties);
        try (InputStream ism = this.resourceLoader.getResource(RSA_KEYS_FILE_PATH).getInputStream();){
            String content = new BufferedReader(new InputStreamReader(ism)).lines().collect(Collectors.joining(System.lineSeparator()));
            JSONObject object = JSONObject.parseObject((String)content);
            String privateKey = object.getString("private");
            String password = properties.getProperty("password");
            char[] charPassword = RSAUtil.decryptByPrivateKey(password, privateKey).toCharArray();
            super.setPassword(charPassword);
        }
        catch (Exception e) {
            LogUtils.error((String)("Druid\u5bc6\u7801\u56de\u8c03\u62a5\u9519\uff1a" + e.getMessage()), (Object[])new Object[0]);
        }
    }
}

