/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.dynamic.spring;

import com.taotao.boot.data.datasource.dynamic.spring.DataSourceContextHolder;
import com.taotao.boot.data.datasource.dynamic.spring.DataSourceTypeEnum;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataSourceAspect {
    @Before(value="@annotation(com.taotao.boot.data.datasource.dynamic.spring.MasterDataSource)")
    public void setMasterDataSource(JoinPoint joinPoint) {
        DataSourceContextHolder.setDataSourceType(DataSourceTypeEnum.MASTER);
    }

    @Before(value="@annotation(com.taotao.boot.data.datasource.dynamic.spring.SlaveDataSource)")
    public void setSlaveDataSource(JoinPoint joinPoint) {
        DataSourceContextHolder.setDataSourceType(DataSourceTypeEnum.SLAVE);
    }

    @After(value="@annotation(com.taotao.boot.data.datasource.dynamic.spring.MasterDataSource) || @annotation(com.taotao.boot.data.datasource.dynamic.spring.SlaveDataSource)")
    public void clearDataSource(JoinPoint joinPoint) {
        DataSourceContextHolder.clearDataSourceType();
    }
}

