/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.dynamic.spring;

import com.taotao.boot.data.datasource.dynamic.spring.DataSourceTypeEnum;
import com.taotao.boot.data.datasource.dynamic.spring.DynamicRoutingDataSource;
import java.util.HashMap;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnProperty(value={"spring.datasource.master.jdbc-url"})
public class DynamicDataSourceConfiguration {
    @Bean(value={"dataSource"})
    @Primary
    public DataSource dynamicDataSource(DataSource masterDataSource, DataSource slaveDataSource) {
        HashMap<DataSourceTypeEnum, DataSource> targetDataSources = new HashMap<DataSourceTypeEnum, DataSource>();
        targetDataSources.put(DataSourceTypeEnum.MASTER, masterDataSource);
        targetDataSources.put(DataSourceTypeEnum.SLAVE, slaveDataSource);
        DynamicRoutingDataSource dynamicDataSource = new DynamicRoutingDataSource();
        dynamicDataSource.setTargetDataSources(targetDataSources);
        dynamicDataSource.setDefaultTargetDataSource(masterDataSource);
        return dynamicDataSource;
    }
}

