/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.ext.doris;

import com.alibaba.druid.pool.DruidDataSource;
import com.taotao.boot.data.datasource.ext.ExtDataSourceCommonProperties;
import com.taotao.boot.data.datasource.ext.ExtDataSourceProperties;
import com.taotao.boot.data.datasource.ext.doris.DorisJdbcBaseDaoImpl;
import com.taotao.boot.data.datasource.ext.trino.TrinoDataSourceConfiguration;
import java.sql.SQLException;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.JdbcClient;

@AutoConfiguration
@ConditionalOnProperty(name={"spring.datasource.doris.enabled"}, havingValue="true")
@Import(value={DorisJdbcBaseDaoImpl.class})
public class DorisDataSourceConfiguration {
    private static Logger logger = LoggerFactory.getLogger(TrinoDataSourceConfiguration.class);
    private final ExtDataSourceProperties extDataSourceProperties;
    private final ExtDataSourceCommonProperties extDataSourceCommonProperties;

    public DorisDataSourceConfiguration(ExtDataSourceProperties extDataSourceProperties, ExtDataSourceCommonProperties extDataSourceCommonProperties) {
        this.extDataSourceProperties = extDataSourceProperties;
        this.extDataSourceCommonProperties = extDataSourceCommonProperties;
    }

    @Bean(value={"dorisDruidDataSource"})
    @Qualifier(value="dorisDruidDataSource")
    public DataSource dorisDruidDataSource() {
        TimeZone.setDefault(TimeZone.getTimeZone("+08:00"));
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(this.extDataSourceProperties.getDoris().getUrl());
        datasource.setUsername(this.extDataSourceProperties.getDoris().getUsername());
        datasource.setPassword(this.extDataSourceProperties.getDoris().getPassword());
        datasource.setDriverClassName(this.extDataSourceProperties.getDoris().getDriverClassName());
        datasource.setInitialSize(this.extDataSourceCommonProperties.getInitialSize());
        datasource.setMinIdle(this.extDataSourceCommonProperties.getMinIdle());
        datasource.setMaxActive(this.extDataSourceCommonProperties.getMaxActive());
        datasource.setMaxWait((long)this.extDataSourceCommonProperties.getMaxWait());
        datasource.setTimeBetweenEvictionRunsMillis((long)this.extDataSourceCommonProperties.getTimeBetweenEvictionRunsMillis());
        datasource.setMinEvictableIdleTimeMillis((long)this.extDataSourceCommonProperties.getMinEvictableIdleTimeMillis());
        datasource.setValidationQuery(this.extDataSourceCommonProperties.getValidationQuery());
        datasource.setTestWhileIdle(this.extDataSourceCommonProperties.isTestWhileIdle());
        datasource.setTestOnBorrow(this.extDataSourceCommonProperties.isTestOnBorrow());
        datasource.setTestOnReturn(this.extDataSourceCommonProperties.isTestOnReturn());
        datasource.setPoolPreparedStatements(this.extDataSourceCommonProperties.isPoolPreparedStatements());
        try {
            datasource.setFilters(this.extDataSourceCommonProperties.getFilters());
        }
        catch (SQLException e) {
            logger.error("Druid configuration initialization filter error.", (Throwable)e);
        }
        return datasource;
    }

    @Bean(name={"dorisJdbcTemplate"})
    public JdbcTemplate dorisJdbcTemplate(@Qualifier(value="dorisDruidDataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Bean(name={"dorisJdbcClient"})
    public JdbcClient dorisJdbcClient(@Qualifier(value="dorisDruidDataSource") DataSource dataSource) {
        return JdbcClient.create((DataSource)dataSource);
    }
}

