/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.init;

import com.taotao.boot.core.enums.TtcEnvEnum;
import com.taotao.boot.core.holder.RuntimeContextHolder;
import com.taotao.boot.data.datasource.init.StandardDatabaseScript;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;

public class DataSourceSqlInvokerBeanProcessor
implements BeanPostProcessor,
Ordered {
    public static final String PRIMARY_DATASOURCE_BEAN_NAME = "dataSource";
    @Autowired
    private ApplicationContext applicationContext;

    public int getOrder() {
        return -2147483646;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSource && this.isPrimaryDataSource((DataSource)bean, beanName) && (TtcEnvEnum.getCurrEnv() != TtcEnvEnum.PRE || TtcEnvEnum.getCurrEnv() != TtcEnvEnum.PRO) && !RuntimeContextHolder.getInstance().isTestEnvironment()) {
            this.applicationContext.getBeansOfType(StandardDatabaseScript.class).forEach((k, v) -> {
                v.setDataSource((DataSource)bean);
                v.execute();
            });
        }
        return bean;
    }

    private boolean isPrimaryDataSource(DataSource dataSource, String beanName) {
        return PRIMARY_DATASOURCE_BEAN_NAME.equals(beanName);
    }
}

