/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.init;

import com.google.common.base.Charsets;
import com.taotao.boot.common.exception.BusinessException;
import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.data.datasource.utils.Jdbcs;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.jdbc.datasource.init.ScriptUtils;
import org.springframework.util.Assert;

public abstract class StandardDatabaseScript {
    private static final Logger logger = LoggerFactory.getLogger(StandardDatabaseScript.class);
    private static final String EVALUATE_SQL_PATTERN = "SELECT count(*) FROM %s";
    private static final String INIT_SQL_PATTERN = "META-INF/database/%s/%s/%s.sql";
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            String componentName = this.getComponentName();
            String evaluateTable = this.getEvaluateTable();
            Assert.notNull((Object)componentName, (String)"\u7ec4\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)evaluateTable, (String)"\u7ec4\u4ef6\u9a8c\u8bc1\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            String evaluateSql = String.format(EVALUATE_SQL_PATTERN, evaluateTable);
            Jdbcs.DbType databaseType = Jdbcs.DbType.MYSQL;
            try (Connection connection = null;){
                connection = this.dataSource.getConnection();
                databaseType = Jdbcs.getDbType(connection.getMetaData().getURL());
                ScriptUtils.executeSqlScript((Connection)connection, (Resource)new ByteArrayResource(evaluateSql.getBytes()));
            }
        }
        catch (SQLException e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public abstract String getEvaluateTable();

    public abstract String getComponentName();

    public abstract List<String> getInitSqlFile();

    protected boolean isContinueOnError() {
        return false;
    }

    private void exeSqlFile(String componentName, Connection connection, String sqlPath) {
        logger.info("\u53d1\u73b0\u7ec4\u4ef6\u6216\u6a21\u5757\uff3b{}\uff3d\u57fa\u7840\u6570\u636e\u8fd8\u6ca1\u6709\u521d\u59cb\u5316\uff0c\u5f00\u59cb\u521d\u59cb\u5316\uff1a{}", (Object)componentName, (Object)sqlPath);
        try {
            Resource scriptResource = ContextUtils.getApplicationContext().getResource("classpath:" + sqlPath);
            EncodedResource encodedResource = new EncodedResource(scriptResource, Charsets.UTF_8);
            ScriptUtils.executeSqlScript((Connection)connection, (EncodedResource)encodedResource, (boolean)this.isContinueOnError(), (boolean)false, (String)"--", (String)";", (String)"/*", (String)"*/");
        }
        catch (Exception e) {
            throw new BusinessException("\u521d\u59cb\u5316" + componentName + "\u5931\u8d25", (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$execute$0(String componentName, Connection conn, String sqlPath) {
        this.exeSqlFile(componentName, conn, sqlPath);
    }
}

