/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.tx;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionBatchOperations {
    public static final Integer DEFAULT_NUM = 1000;
    private final TransactionTemplate transactionTemplate;
    private Executor executor;

    public TransactionBatchOperations(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public TransactionBatchOperations(TransactionTemplate transactionTemplate, Executor executor) {
        this(transactionTemplate);
        this.executor = executor;
    }

    public <T> void executeBatch(List<T> dataList, Consumer<List<T>> ops) {
        this.executeBatch(dataList, DEFAULT_NUM, ops);
    }

    public <T> void executeBatch(List<T> dataList, int batchNum, Consumer<List<T>> ops) {
        List partition = Lists.partition(dataList, (int)batchNum);
        AtomicBoolean rollback = new AtomicBoolean(false);
        ArrayList futures = new ArrayList(partition.size());
        partition.forEach(item -> {
            CompletableFuture<Void> future = this.execute(() -> this.transactionTemplate.execute(status -> {
                try {
                    ops.accept((List)item);
                }
                catch (Exception e) {
                    rollback.compareAndSet(false, true);
                }
                finally {
                    if (rollback.get()) {
                        status.setRollbackOnly();
                    }
                }
                return true;
            }));
            futures.add(future);
        });
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        if (rollback.get()) {
            throw new RuntimeException();
        }
    }

    private CompletableFuture<Void> execute(Runnable runnable) {
        if (this.executor == null) {
            return CompletableFuture.runAsync(runnable);
        }
        return CompletableFuture.runAsync(runnable, this.executor);
    }
}

