/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.tx;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionSynchronizationManagerUtil {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public void sendLog() {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            this.executor.submit(() -> {});
            return;
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void beforeCommit(boolean readOnly) {
                System.out.println("Before commit: Check data integrity");
            }

            public void afterCommit() {
                System.out.println("After commit: Send notification");
            }

            public void beforeCompletion() {
                System.out.println("Before completion: Log transaction status");
            }

            public void afterCompletion(int status) {
                if (status == 0) {
                    TransactionSynchronizationManagerUtil.this.executor.submit(() -> {});
                }
            }
        });
    }
}

