/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.tx;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.function.Consumer;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionalUtils {
    private final TransactionTemplate transactionTemplate;
    private static final ThreadLocal<TransactionTemplate> TRANSACTION_LOCAL = new TransmittableThreadLocal();

    public TransactionalUtils(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public <T> T execute(TransactionCallback<T> action) {
        return (T)this.transactionTemplate.execute(action);
    }

    public void executeWithoutResult(Consumer<TransactionStatus> action) {
        this.transactionTemplate.executeWithoutResult(action);
    }

    public void set() {
        TRANSACTION_LOCAL.set(this.transactionTemplate);
    }

    public void remove() {
        TRANSACTION_LOCAL.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(TransactionCallback<T> action, int propagationBehavior, int isolationLevel, boolean readOnly) {
        try {
            this.set();
            Object object = this.convert(propagationBehavior, isolationLevel, readOnly).execute(action);
            return (T)object;
        }
        finally {
            this.remove();
        }
    }

    public <T> T defaultExecute(TransactionCallback<T> action, int isolationLevel, boolean readOnly) {
        return this.execute(action, 0, isolationLevel, readOnly);
    }

    public <T> T defaultExecute(TransactionCallback<T> action) {
        return this.execute(action, 0, 2, false);
    }

    public <T> T newExecute(TransactionCallback<T> action, int isolationLevel, boolean readOnly) {
        return this.execute(action, 3, isolationLevel, readOnly);
    }

    public <T> T newExecute(TransactionCallback<T> action) {
        return this.execute(action, 3, 2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithoutResult(Consumer<TransactionStatus> action, int propagationBehavior, int isolationLevel, boolean readOnly) {
        try {
            this.set();
            this.convert(propagationBehavior, isolationLevel, readOnly).executeWithoutResult(action);
        }
        finally {
            this.remove();
        }
    }

    public void defaultExecuteWithoutResult(Consumer<TransactionStatus> action, int isolationLevel, boolean readOnly) {
        this.executeWithoutResult(action, 0, isolationLevel, readOnly);
    }

    public void defaultExecuteWithoutResult(Consumer<TransactionStatus> action) {
        this.executeWithoutResult(action, 0, 2, false);
    }

    public void newExecuteWithoutResult(Consumer<TransactionStatus> action) {
        this.executeWithoutResult(action, 3, 2, false);
    }

    public void newExecuteWithoutResult(Consumer<TransactionStatus> action, int isolationLevel, boolean readOnly) {
        this.executeWithoutResult(action, 3, isolationLevel, readOnly);
    }

    private TransactionTemplate convert(int propagationBehavior, int isolationLevel, boolean readOnly) {
        TransactionTemplate transactionTemplate = TRANSACTION_LOCAL.get();
        transactionTemplate.setPropagationBehavior(propagationBehavior);
        transactionTemplate.setIsolationLevel(isolationLevel);
        transactionTemplate.setReadOnly(readOnly);
        return transactionTemplate;
    }
}

