/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.utils;

import com.google.common.collect.Lists;
import com.taotao.boot.common.utils.log.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class BatchUtils<T> {
    private final PlatformTransactionManager platformTransactionManager;
    private final ThreadPoolTaskExecutor taskExecutor;

    public BatchUtils(PlatformTransactionManager platformTransactionManager, @Qualifier(value="asyncThreadPoolTaskExecutor") ThreadPoolTaskExecutor taskExecutor) {
        this.platformTransactionManager = platformTransactionManager;
        this.taskExecutor = taskExecutor;
    }

    public TransactionTemplate transactionTemplate() {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.platformTransactionManager);
        transactionTemplate.setReadOnly(false);
        transactionTemplate.setPropagationBehavior(0);
        transactionTemplate.setIsolationLevel(2);
        transactionTemplate.setTimeout(120);
        transactionTemplate.setName("taotao-transaction-template");
        return transactionTemplate;
    }

    public void insertBatch(List<T> dataList, int batchNum, Consumer<List<T>> service) {
        List partition = Lists.partition(dataList, (int)batchNum);
        AtomicBoolean rollback = new AtomicBoolean(false);
        ArrayList futures = new ArrayList(partition.size());
        partition.forEach(item -> futures.add(CompletableFuture.runAsync(() -> this.transactionTemplate().executeWithoutResult(callback -> {
            try {
                service.accept((List)item);
            }
            catch (Exception e) {
                rollback.compareAndSet(false, true);
                LogUtils.error((String)"\u9519\u8bef\u4fe1\u606f\uff1a\u6279\u91cf\u63d2\u5165\u6570\u636e\u5f02\u5e38\uff0c\u8bbe\u7f6e\u56de\u6eda\u6807\u8bc6", (Object[])new Object[0]);
            }
            finally {
                if (rollback.get()) {
                    callback.setRollbackOnly();
                }
            }
        }), (Executor)this.taskExecutor)));
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        if (rollback.get()) {
            throw new RuntimeException("\u6279\u91cf\u63d2\u5165\u6570\u636e\u5f02\u5e38\uff0c\u6570\u636e\u5df2\u56de\u6eda");
        }
    }
}

