/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.utils;

import com.taotao.boot.common.utils.common.JsonUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class DbTableUtils {
    private DbTableUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyTableSchema(String sourceTableName, String targetTableName, DataSource dataSource) {
        boolean result = false;
        String copyTableSql = String.format("CREATE TABLE %s LIKE %s", targetTableName, sourceTableName);
        try (Connection connection = dataSource.getConnection();
             PreparedStatement pstat = connection.prepareStatement(copyTableSql);){
            pstat.executeUpdate();
            result = true;
        }
        catch (SQLException e) {
            try {
                LogUtils.error((String)e.getMessage(), (Object[])new Object[]{e});
            }
            catch (Throwable throwable) {
                LogUtils.warn((String)"execute sql==>{}", (Object[])new Object[]{copyTableSql});
                throw throwable;
            }
            LogUtils.warn((String)"execute sql==>{}", (Object[])new Object[]{copyTableSql});
        }
        LogUtils.warn((String)"execute sql==>{}", (Object[])new Object[]{copyTableSql});
        return result;
    }

    public static boolean createTableIfAbsent(String targetDbName, String sourceTableName, String targetTableName, DataSource dataSource) {
        boolean result = true;
        try {
            boolean exist = DbTableUtils.existTable(targetDbName, (String)targetTableName, dataSource);
            if (!exist) {
                if (targetDbName != null) {
                    targetTableName = targetDbName + "." + (String)targetTableName;
                }
                result = DbTableUtils.copyTableSchema(sourceTableName, (String)targetTableName, dataSource);
            }
        }
        catch (Exception e) {
            LogUtils.error((String)e.getMessage(), (Object[])new Object[]{e});
            result = false;
        }
        return result;
    }

    public static boolean existTable(String targetDbName, String tableName, DataSource dataSource) {
        List<String> tables = DbTableUtils.queryTables(targetDbName, tableName, false, dataSource);
        return tables.contains(tableName);
    }

    public static List<String> queryTablesByPrefix(String targetDbName, String tableNamePrefix, DataSource dataSource) {
        return DbTableUtils.queryTables(targetDbName, tableNamePrefix, true, dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> queryTables(String targetDbName, String tableName, boolean prefix, DataSource dataSource) {
        if (prefix) {
            tableName = (String)tableName + "%";
        }
        ArrayList<String> tablesWithPrefix = new ArrayList<String>();
        try (Connection connection = dataSource.getConnection();){
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(targetDbName, null, (String)tableName, null);
            while (resultSet.next()) {
                tablesWithPrefix.add(resultSet.getString(3));
            }
        }
        catch (SQLException e) {
            try {
                LogUtils.error((String)e.getMessage(), (Object[])new Object[]{e});
            }
            catch (Throwable throwable) {
                LogUtils.debug((String)"queryTables|tableName={}, result={}", (Object[])new Object[]{tableName, JsonUtils.toJson(tablesWithPrefix)});
                throw throwable;
            }
            LogUtils.debug((String)"queryTables|tableName={}, result={}", (Object[])new Object[]{tableName, JsonUtils.toJson(tablesWithPrefix)});
        }
        LogUtils.debug((String)"queryTables|tableName={}, result={}", (Object[])new Object[]{tableName, JsonUtils.toJson(tablesWithPrefix)});
        return tablesWithPrefix;
    }
}

