/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.utils;

import com.taotao.boot.common.utils.log.LogUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DbUtils {
    private DbUtils() {
    }

    public static boolean createDbIfAbsent(String dbName, DataSource dataSource) {
        return DbUtils.createDbIfAbsent(dbName, "utf8", dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createDbIfAbsent(String dbName, String charset, DataSource dataSource) {
        boolean result = false;
        String createDbSql = String.format("CREATE DATABASE IF NOT EXISTS %s CHARACTER SET %s", dbName, charset);
        try (Connection connection = dataSource.getConnection();
             PreparedStatement pstat = connection.prepareStatement(createDbSql);){
            pstat.executeUpdate();
            result = true;
        }
        catch (SQLException e) {
            try {
                LogUtils.error((String)e.getMessage(), (Object[])new Object[]{e});
            }
            catch (Throwable throwable) {
                LogUtils.warn((String)"execute sql==>{}", (Object[])new Object[]{createDbSql});
                throw throwable;
            }
            LogUtils.warn((String)"execute sql==>{}", (Object[])new Object[]{createDbSql});
        }
        LogUtils.warn((String)"execute sql==>{}", (Object[])new Object[]{createDbSql});
        return result;
    }
}

